/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToblerHyperelliptical
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Tobler Hyperelliptical";
    private static final double DEFAULT_ALPHA = 0.0;
    private static final double DEFAULT_GAMMA = 1.183136;
    private static final double DEFAULT_K = 2.5;
    private double alpha_ = 0.0;
    private double gamma_ = 1.183136;
    private double kterm_ = 2.5;
    private double alphaM1_ = this.alpha_ - 1.0;
    private double invGamma_ = 1.0 / this.gamma_;
    private double invK_ = 1.0 / this.kterm_;
    private double alphaM1OverGamma_ = this.alphaM1_ * this.invGamma_;
    private double gammaToTheK_ = Math.pow(this.gamma_, this.kterm_);
    private double affineSq_ = 1.0;
    private double invaffineSq_ = 1.0;
    private int failures_;

    public ToblerHyperelliptical(int width, int height) {
        this(width, height, 0, 0);
    }

    public ToblerHyperelliptical(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public ToblerHyperelliptical(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.autoscale();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
    }

    public void setCEAWeight(double ceaWgt) {
        this.alpha_ = ceaWgt;
        this.autoscale();
    }

    public void setGamma(double gamma) {
        this.gamma_ = gamma;
        this.autoscale();
    }

    public void setK(double k) {
        this.kterm_ = k;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        this.alphaM1_ = this.alpha_ - 1.0;
        this.invGamma_ = 1.0 / this.gamma_;
        this.invK_ = 1.0 / this.kterm_;
        this.alphaM1OverGamma_ = this.alphaM1_ * this.invGamma_;
        this.gammaToTheK_ = Math.pow(this.gamma_, this.kterm_);
        double yf = this.iteratePhiToUnscaledY(90.0, true);
        this.affineSq_ = Double.isNaN(yf) || Double.isInfinite(yf) ? 1.0 : 1.5707963267948966 / yf;
        this.invaffineSq_ = 1.0 / this.affineSq_;
        this.setSizeFactors(Math.PI, 1.5707963267948966);
    }

    @Override
    protected void finishScaling() {
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        if (absLat < 1.0E-10) {
            x = lambdaRad;
            y = 0.0;
        } else if (this.alpha_ == 1.0) {
            double phiRad = Math.toRadians(absLat);
            double sinPhi = Math.sin(phiRad);
            x = lambdaRad;
            y = sinPhi;
        } else if (this.alpha_ == 0.0 && absLat > 89.99999) {
            y = this.gamma_;
            x = lambdaRad * (this.alpha_ - this.alphaM1OverGamma_ * this.hyperelliptic(y, false));
        } else {
            y = this.iteratePhiToUnscaledY(absLat, false);
            if (Double.isNaN(y) || Double.isInfinite(y)) {
                return null;
            }
            x = lambdaRad * (this.alpha_ - this.alphaM1OverGamma_ * this.hyperelliptic(y, false));
        }
        y *= this.affineSq_;
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double sinPhi;
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absY = Math.abs(y);
        if (Math.abs(x) > (double)this.dxMax_ || absY > (double)this.dyMax_) {
            return null;
        }
        if (absY > this.ymRS_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = absY * this.invRS_ * this.invaffineSq_;
        if (absY < 1.0E-5) {
            lambdaRad = xOverRS;
            sinPhi = 0.0;
        } else if (this.alpha_ == 1.0) {
            lambdaRad = xOverRS;
            sinPhi = yOverRS;
        } else {
            lambdaRad = xOverRS / (this.alpha_ - this.alphaM1OverGamma_ * this.hyperelliptic(yOverRS, false));
            sinPhi = this.alpha_ * yOverRS - this.alphaM1OverGamma_ * this.integral(yOverRS);
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phiRad = Math.asin(sinPhi);
        if (x < 0.0) {
            phiRad = -phiRad;
        }
        if (y < 0.0) {
            phiRad = -phiRad;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        ToblerHyperelliptical toblerHyperelliptical = this;
        synchronized (toblerHyperelliptical) {
            double y;
            double phiRad = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
                double x;
                double xOverRS;
                double lambdaRad;
                double xTerm;
                double yOverRS = y * this.invRS_ * this.invaffineSq_;
                if (this.alpha_ == 1.0) {
                    phiRad = Math.asin(yOverRS);
                    xTerm = 1.0;
                } else {
                    double sinPhi = this.alpha_ * y - this.alphaM1OverGamma_ * this.integral(yOverRS);
                    phiRad = Math.asin(sinPhi);
                    xTerm = 1.0 / (this.alpha_ - this.alphaM1OverGamma_ * this.hyperelliptic(yOverRS, false));
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (xOverRS = (x = (double)ix + 0.5) * this.invRS_) * xTerm) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private double iteratePhiToUnscaledY(double absphi, boolean debug) {
        if (this.alpha_ == 0.0 && absphi > 89.99999) {
            return this.gamma_;
        }
        double phiRad = Math.toRadians(absphi);
        double sinPhi = Math.sin(phiRad);
        if (this.alpha_ == 1.0) {
            return sinPhi;
        }
        double y = (this.alpha_ + this.gamma_ * (1.0 - this.alpha_)) * phiRad / 1.5707963267948966;
        if (y > this.gamma_) {
            y *= 0.5;
        }
        for (int iter = 0; iter < 33; ++iter) {
            double integral = this.integral(y);
            double hyper = this.hyperelliptic(y, debug);
            double func = sinPhi - this.alpha_ * y + this.alphaM1OverGamma_ * integral;
            double dfunc = -this.alpha_ + this.alphaM1OverGamma_ * hyper;
            double dy = -func / dfunc;
            if (debug) {
                LOGGER.debug("Iteration {} for {}", (Object)iter, (Object)absphi);
                LOGGER.debug(" -- hyper {}, integral {}", (Object)hyper, (Object)integral);
                LOGGER.debug(" -- func {}, dfunc {}", (Object)func, (Object)dfunc);
                LOGGER.debug(" -- y {}, dy {}, y {}", y, dy, y + dy);
            }
            if ((y += dy) > this.gamma_) {
                y = this.gamma_ - 1.0E-5;
            }
            if (Math.abs(dy) < 1.0E-5) break;
        }
        return y;
    }

    private double hyperelliptic(double y, boolean debug) {
        double yToTheK = Math.pow(y, this.kterm_);
        double diff = this.gammaToTheK_ - yToTheK;
        double result = Math.pow(diff, this.invK_);
        if (debug && (Double.isNaN(result) || Double.isInfinite(result))) {
            LOGGER.debug("   y {}, y^k {}", (Object)y, (Object)yToTheK);
            LOGGER.debug("   g {}, g^k {}", (Object)this.gamma_, (Object)this.gammaToTheK_);
            LOGGER.debug("   diff {}, result {}", (Object)diff, (Object)result);
        }
        return result;
    }

    private double integral(double y) {
        return this.adaptive(0.0, y, 1.0E-5);
    }

    private double adaptive(double a, double b, double epsilon) {
        double q1;
        double fe;
        double h = b - a;
        double c = 0.5 * (a + b);
        double d = 0.5 * (a + c);
        double e = 0.5 * (b + c);
        double fa = this.hyperelliptic(a, false);
        double fb = this.hyperelliptic(b, false);
        double fc = this.hyperelliptic(c, false);
        double fd = this.hyperelliptic(d, false);
        double q2 = h * (fa + 4.0 * fd + 2.0 * fc + 4.0 * (fe = this.hyperelliptic(e, false)) + fb) / 12.0;
        if (Math.abs(q2 - (q1 = h * (fa + 4.0 * fc + fb) / 6.0)) > epsilon) {
            try {
                return this.adaptive(a, c, epsilon) + this.adaptive(c, b, epsilon);
            }
            catch (Exception exc) {
                LOGGER.trace("failure {}", (Object)(++this.failures_));
            }
        }
        return q2 + (q2 - q1) / 15.0;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.alpha_ < 1.0) {
            super.drawBorderLines(g2d);
        } else {
            ProjectionUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        if (this.alpha_ < 1.0) {
            super.drawMeridian(g2d, lon, label);
        } else {
            double dlon = MapUtils.normalize360(lon - this.lambdaC_);
            if (Math.abs(dlon - 180.0) < 1.0E-5) {
                return;
            }
            Point2D.Double dot = this.transformLL2XY(lon, 0.0);
            if (dot == null) {
                return;
            }
            float top = this.outCenterY_ - this.dyMax_;
            float bottom = this.outCenterY_ + this.dyMax_;
            GraphicUtils.drawLine(g2d, dot.x, top, dot.x, bottom);
        }
    }
}

