/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.TwoHemisphereAzimuthalProjection;
import java.awt.Dimension;

public class Stereographic2H
extends TwoHemisphereAzimuthalProjection {
    public static final String PROJECTION_NAME = "Stereographic (Two-Hemisphere)";
    public static final int PROPERTIES = 0x2200040;
    private static final double RADIUS_FACTOR = 2.0;

    public Stereographic2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public Stereographic2H(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Stereographic2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x2200040, width, height, xmargin, ymargin, 2.0);
    }

    @Override
    protected double getKForLambdaPPhiP(double lambdaPRad, double phiPRad) {
        double cosZ = Math.cos(phiPRad) * Math.cos(lambdaPRad);
        if (cosZ == 1.0) {
            return 0.0;
        }
        return 2.0 / (1.0 + cosZ);
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        return 2.0 * Math.atan(0.5 * rhoRS * this.invRS_);
    }
}

