/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class SolovevModifiedBonne
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Solov'ev Modified Bonne";
    public static final int PROPERTIES = 512;
    private static final double DEFAULT_PHI1 = 52.3;
    private static final double WIDTH_FACTOR = Math.PI * 2;
    private static final double HEIGHT_FACTOR = Math.PI;
    private double phi1_ = 52.3;
    private double phi1Rad_;
    private double cotPhi1_;
    private double yshift_;
    private double lobeTipLat_;
    private static final double CONST_C1 = 1.02;
    private static final double CONST_C2 = 0.95;
    private static final double INV_C1 = 0.9803921568627451;
    private static final double INV_C2 = 1.0526315789473684;
    private static final double CENTER_LON = 90.0;
    private static final double MAX_DLAMBDA = 110.0;
    private static final double MAX_DLAMBDA_RAD = Math.toRadians(110.0);
    private static final double ALMOST_MAX_DLAMBDA = 109.99999;
    private static final double C2_MAX_DLAMBDA_RAD = 0.95 * MAX_DLAMBDA_RAD;
    private static final double MIN_PHI = 30.0;
    private static final double MIN_PHI_RAD = Math.toRadians(30.0);

    public SolovevModifiedBonne(int width, int height) {
        this(width, height, 0, 0);
    }

    public SolovevModifiedBonne(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public SolovevModifiedBonne(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 512, width, height, xmargin, ymargin, Math.PI * 2, Math.PI);
        this.autoscale();
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(90.0, lat);
    }

    @Override
    protected void prepareScaling() {
        this.phi1Rad_ = Math.toRadians(this.phi1_);
        this.cotPhi1_ = 1.0 / Math.tan(this.phi1Rad_);
        double latX = 30.0;
        double phiRad = Math.toRadians(30.0);
        double rhoRad = this.cotPhi1_ + 1.02 * (this.phi1Rad_ - phiRad);
        double thetaRad = C2_MAX_DLAMBDA_RAD * Math.cos(phiRad) / rhoRad;
        double widthFactor = rhoRad * Math.sin(thetaRad);
        double rhoRad2 = this.cotPhi1_ + 1.02 * (this.phi1Rad_ - 1.5707963267948966);
        double y1 = this.cotPhi1_ - rhoRad2;
        double lobeTipLat = this.latitudeOfLobeMaxY();
        phiRad = Math.toRadians(lobeTipLat);
        rhoRad = this.cotPhi1_ + 1.02 * (this.phi1Rad_ - phiRad);
        thetaRad = C2_MAX_DLAMBDA_RAD * Math.cos(phiRad) / rhoRad;
        double lobeY = this.cotPhi1_ - rhoRad * Math.cos(thetaRad);
        y1 = Math.max(y1, lobeY);
        double phiRad2 = MIN_PHI_RAD;
        double rhoRad3 = this.cotPhi1_ + 1.02 * (this.phi1Rad_ - phiRad2);
        double y2 = this.cotPhi1_ - rhoRad3;
        this.yshift_ = -0.5 * (y1 + y2);
        double heightFactor = 0.5 * Math.abs(y1 - y2);
        this.setSizeFactors(widthFactor, heightFactor);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        if (lat < 30.0) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double rhoRad = this.cotPhi1_ + 1.02 * (this.phi1Rad_ - phiRad);
        if (Math.abs(rhoRad) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - this.yshift_ * this.rS_);
        }
        double lambda = MapUtils.normalizeMP180(lon - 90.0);
        if (Math.abs(lambda) > 110.0) {
            return null;
        }
        double lambdaRad = Math.toRadians(lambda);
        double thetaRad = 0.95 * lambdaRad * Math.cos(phiRad) / rhoRad;
        double x = rhoRad * Math.sin(thetaRad);
        double y = this.yshift_ + this.cotPhi1_ - rhoRad * Math.cos(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double yOverRS;
        double y1;
        double xOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double pmFac = this.phi1_ < 0.0 ? -1.0 : 1.0;
        double rhoRad = pmFac * Math.hypot(xOverRS = x * this.invRS_, y1 = this.cotPhi1_ - (yOverRS = y * this.invRS_ - this.yshift_));
        double phiRad = (this.cotPhi1_ - rhoRad) * 0.9803921568627451 + this.phi1Rad_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double thetaRad = Math.atan2(pmFac * xOverRS, pmFac * y1);
        double lambdaRad = thetaRad * rhoRad * 1.0526315789473684 / Math.cos(phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        if (Math.abs(lambda) > 110.0) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        if (phi < 30.0) {
            return null;
        }
        return new PointLL(90.0 + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        SolovevModifiedBonne solovevModifiedBonne = this;
        synchronized (solovevModifiedBonne) {
            double pmFac = this.phi1_ < 0.0 ? -1.0 : 1.0;
            block3: for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - this.yshift_;
                double y1 = this.cotPhi1_ - yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double rhoRad = pmFac * Math.hypot(xOverRS, y1);
                    double phiRad = (this.cotPhi1_ - rhoRad) * 0.9803921568627451 + this.phi1Rad_;
                    if (Math.abs(phiRad) > 1.5707963267948966) continue;
                    double thetaRad = Math.atan2(pmFac * xOverRS, pmFac * y1);
                    double lambdaRad = thetaRad * rhoRad * 1.0526315789473684 / Math.cos(phiRad);
                    double lambda = Math.toDegrees(lambdaRad);
                    double phi = Math.toDegrees(phiRad);
                    if (lambda > 110.0) {
                        if (!(Math.abs(this.phi1_) < 11.5232593818)) continue;
                        continue block3;
                    }
                    if (phi < 30.0) continue;
                    this.set2SymmetricPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier bcurve = this.makeMeridianBezier(199.99999);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeMeridianBezier(-19.999989999999997)) != null) {
            bcurve.draw(g2d);
        }
        double lon1 = -19.999989999999997;
        double lon2 = 90.0;
        double lon3 = 199.99999;
        Point2D.Double dot1 = this.transformLL2XY(-19.999989999999997, 30.0);
        Point2D.Double dot2 = this.transformLL2XY(90.0, 30.0);
        Point2D.Double dot3 = this.transformLL2XY(199.99999, 30.0);
        if (dot1 == null || dot2 == null || dot3 == null) {
            return;
        }
        GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat <= 30.0) {
            return;
        }
        double lon1 = -19.999989999999997;
        double lon2 = 90.0;
        double lon3 = 199.99999;
        Point2D.Double dot1 = this.transformLL2XY(-19.999989999999997, lat);
        Point2D.Double dot2 = this.transformLL2XY(90.0, lat);
        Point2D.Double dot3 = this.transformLL2XY(199.99999, lat);
        if (dot1 == null || dot2 == null || dot3 == null) {
            return;
        }
        GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double dlon = MapUtils.normalize360(lon - 90.0);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        try {
            Bezier bcurve = this.makeMeridianBezier(lon);
            if (bcurve != null) {
                bcurve.draw(g2d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Bezier makeMeridianBezier(double lon) {
        Point2D.Double dot;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(240);
        double lat = 20.0;
        while (lat < 90.0) {
            double absLat;
            dot = this.transformLL2XY(lon, lat);
            if (dot != null) {
                ptlist.add(new Point2D.Double(dot.x, dot.y));
            }
            if ((absLat = Math.abs(lat)) >= 89.0) {
                lat += 0.1;
                continue;
            }
            if (absLat >= 85.0) {
                lat += 0.25;
                continue;
            }
            lat += 0.5;
        }
        dot = this.transformLL2XY(lon, 90.0);
        ptlist.add(new Point2D.Double(dot.x, dot.y));
        return new Bezier(false, ptlist);
    }

    private double latitudeOfLobeMaxY() {
        if (Math.abs(this.phi1_) <= 11.5232593818) {
            return Double.NaN;
        }
        double drhoRad = -1.02;
        double phiRad = Math.toRadians(45.0);
        if (this.phi1_ < 0.0) {
            phiRad = -phiRad;
        }
        for (int iter = 0; iter < 33; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double rhoRad = this.cotPhi1_ + 1.02 * (this.phi1Rad_ - phiRad);
            double rhoRad2 = rhoRad * rhoRad;
            double thetaRad = C2_MAX_DLAMBDA_RAD * cosPhi / rhoRad;
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double dthetaRad = -C2_MAX_DLAMBDA_RAD * sinPhi / rhoRad + thetaRad * 1.02 / rhoRad;
            double d2thetaRad = -C2_MAX_DLAMBDA_RAD * cosPhi / rhoRad + C2_MAX_DLAMBDA_RAD * sinPhi * -1.02 / rhoRad2 + dthetaRad * 1.02 / rhoRad + thetaRad * 1.02 * 1.02 / rhoRad2;
            double dsinTheta = cosTheta * dthetaRad;
            double dcosTheta = -sinTheta * dthetaRad;
            double d2cosTheta = -(dsinTheta * dthetaRad + sinTheta * d2thetaRad);
            double func = 1.02 * cosTheta - rhoRad * dcosTheta;
            double dfunc = 1.02 * dcosTheta - -1.02 * dcosTheta - rhoRad * d2cosTheta;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return Math.toDegrees(phiRad);
    }
}

