/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.ModifiedStereographicProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnyderGS50
extends ModifiedStereographicProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Snyder GS50";
    public static final int PROPERTIES = 5120;
    private static final double WIDTH_FACTOR = 0.9757624759866018;
    private static final double HEIGHT_FACTOR = 0.6376693045070022;
    private static final double LAMBDA0 = -120.0;
    private static final double PHI1 = 45.0;
    private static final double XSHIFT = 0.02324157951940409;
    private static final double YSHIFT = -0.08330131808400791;
    private static final double A1 = 0.984299;
    private static final double A2 = 0.0211642;
    private static final double A3 = -0.1036018;
    private static final double A4 = -0.0329095;
    private static final double A5 = 0.0499471;
    private static final double A6 = 0.026046;
    private static final double A7 = 7.388E-4;
    private static final double A8 = 0.0075848;
    private static final double A9 = -0.0216473;
    private static final double A10 = -0.0225161;
    private static final double B1 = 0.0;
    private static final double B2 = 0.0037608;
    private static final double B3 = -0.0575102;
    private static final double B4 = -0.0320119;
    private static final double B5 = 0.1223335;
    private static final double B6 = 0.0899805;
    private static final double B7 = -0.1435792;
    private static final double B8 = -0.1334108;
    private static final double B9 = 0.0776645;
    private static final double B10 = 0.0853673;
    private static final double[] CAP_A = new double[]{0.0, 0.984299, 0.0211642, -0.1036018, -0.0329095, 0.0499471, 0.026046, 7.388E-4, 0.0075848, -0.0216473, -0.0225161};
    private static final double[] CAP_B = new double[]{0.0, 0.0, 0.0037608, -0.0575102, -0.0320119, 0.1223335, 0.0899805, -0.1435792, -0.1334108, 0.0776645, 0.0853673};
    private static final double[][] BORDER_SEGMENTS = new double[][]{{170.0, 170.0, 25.0, 75.0}, {170.0, 295.0, 75.0, 75.0}, {-65.0, -65.0, 75.0, 70.0}, {-65.0, -60.0, 70.0, 70.0}, {-60.0, -60.0, 70.0, 65.0}, {-60.0, -55.0, 65.0, 65.0}, {-55.0, -55.0, 65.0, 60.0}, {-55.0, -50.0, 60.0, 60.0}, {-50.0, -50.0, 60.0, 40.0}, {-50.0, -55.0, 40.0, 40.0}, {-55.0, -55.0, 40.0, 30.0}, {-55.0, -65.0, 30.0, 30.0}, {-65.0, -65.0, 30.0, 15.0}, {-65.0, -180.0, 15.0, 15.0}, {180.0, 180.0, 15.0, 25.0}, {180.0, 170.0, 25.0, 25.0}};
    private Bezier[] borderCurves_;

    public SnyderGS50(int width, int height) {
        this(width, height, 0, 0);
    }

    public SnyderGS50(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public SnyderGS50(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 5120, width, height, xmargin, ymargin, 0.9757624759866018, 0.6376693045070022, -120.0, 45.0, 0.02324157951940409, -0.08330131808400791, CAP_A, CAP_B);
        this.finishScaling();
    }

    @Override
    protected final void finishScaling() {
        this.borderCurves_ = null;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.borderCurves_ == null) {
            this.borderCurves_ = this.makeBorderBezier();
        }
        int icount = 0;
        for (Bezier curve : this.borderCurves_) {
            try {
                if (curve != null) {
                    curve.draw(g2d);
                }
            }
            catch (Exception exc) {
                LOGGER.error("Exception drawing segment {}", (Object)icount);
            }
            ++icount;
        }
    }

    private Bezier[] makeBorderBezier() {
        Bezier[] curves = new Bezier[BORDER_SEGMENTS.length];
        for (int i = 0; i < BORDER_SEGMENTS.length; ++i) {
            Point2D.Double dot;
            int j;
            int np;
            double lon1 = BORDER_SEGMENTS[i][0];
            double lon2 = BORDER_SEGMENTS[i][1];
            double lat1 = BORDER_SEGMENTS[i][2];
            double lat2 = BORDER_SEGMENTS[i][3];
            ArrayList<Point2D.Double> alist = new ArrayList<Point2D.Double>(100);
            if (lon1 == lon2) {
                np = (int)Math.abs(lat2 - lat1);
                double dlat = (lat2 - lat1) / (double)np;
                for (j = 0; j <= np; ++j) {
                    double lat = lat1 + dlat * (double)j;
                    dot = this.transformLL2XY(lon1, lat);
                    if (dot == null) {
                        LOGGER.warn("LON segment {} : {}, {}", i, lon1, lat);
                        break;
                    }
                    alist.add(new Point2D.Double(dot.x, dot.y));
                }
            } else {
                np = (int)Math.abs(lon2 - lon1);
                double dlon = (lon2 - lon1) / (double)np;
                for (j = 0; j <= np; ++j) {
                    double lon = lon1 + dlon * (double)j;
                    dot = this.transformLL2XY(lon, lat1);
                    if (dot == null) {
                        LOGGER.warn("LAT segment {} : {}, {}", i, lon, lat1);
                        break;
                    }
                    alist.add(new Point2D.Double(dot.x, dot.y));
                }
            }
            curves[i] = new Bezier(false, alist);
        }
        return curves;
    }

    @Override
    public boolean isWithinBounds(double lon, double lat) {
        if (lat > 75.0 || lat < 15.0) {
            return false;
        }
        double xlon = MapUtils.normalizeMP180(lon);
        if (xlon > -50.0 && xlon < 170.0) {
            return false;
        }
        if (xlon > 0.0 && xlon < 180.0 && lat < 25.0) {
            return false;
        }
        if (xlon > 0.0) {
            return true;
        }
        if (xlon > -55.0 && lat > 60.0) {
            return false;
        }
        if (xlon > -55.0 && lat < 40.0) {
            return false;
        }
        if (xlon > -60.0 && lat > 65.0) {
            return false;
        }
        if (xlon > -65.0 && lat < 30.0) {
            return false;
        }
        return !(xlon > -65.0) || !(lat > 70.0);
    }

    @Override
    public LonLatBounds getBounds() {
        return new LonLatBounds(-190.0, 75.0, -50.0, 15.0);
    }
}

