/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class QuarticAuthalic
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Quartic Authalic";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.4142135623730951;

    public QuarticAuthalic(int width, int height) {
        this(width, height, 0, 0);
    }

    public QuarticAuthalic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public QuarticAuthalic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x1000008, width, height, xmargin, ymargin, Math.PI, 1.4142135623730951);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        if (lat == 0.0 && !this.isShowingInterrupted()) {
            double x2 = this.lonToLambdaRad(lon);
            double y = 0.0;
            x2 = (double)this.outCenterX_ + x2 * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x2, y);
        }
        double phiRad = Math.toRadians(lat);
        double halfPhiRad = 0.5 * phiRad;
        double phiFactor = Math.cos(phiRad) / Math.cos(halfPhiRad);
        double y = 2.0 * Math.sin(halfPhiRad);
        if (this.isShowingInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double clon = gore[1];
            double dlon = MapUtils.normalizeMP180(lon) - clon;
            if (MapUtils.normalizeMP180(lon) > gore[2]) {
                dlon -= 360.0;
            }
            double dx = Math.toRadians(dlon) * phiFactor;
            double cx = this.lonToLambdaRad(clon);
            x = cx + dx;
        } else {
            x = this.lonToLambdaRad(lon) * phiFactor;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (y == 0.0) {
            phiRad = 0.0;
            xFactor = this.invRS_;
        } else {
            double yOverRS = y * this.invRS_;
            double sinHalfPhi = 0.5 * yOverRS;
            double halfPhiRad = Math.asin(sinHalfPhi);
            phiRad = 2.0 * halfPhiRad;
            xFactor = this.invRS_ * Math.cos(halfPhiRad) / Math.cos(phiRad);
        }
        double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        QuarticAuthalic quarticAuthalic = this;
        synchronized (quarticAuthalic) {
            double y;
            double sinHalfPhi;
            double halfPhiRad;
            double phiRad;
            for (int iy = -this.dyMax_; iy < this.dyMax_ && !((phiRad = 2.0 * (halfPhiRad = Math.asin(sinHalfPhi = 0.5 * (y = (double)iy + 0.5) * this.invRS_))) > 1.5707963267948966); ++iy) {
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ * Math.cos(halfPhiRad) / Math.cos(phiRad);
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

