/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.TwoHemisphereAzimuthalProjection;
import java.awt.Dimension;

public class Orthographic2H
extends TwoHemisphereAzimuthalProjection {
    public static final String PROJECTION_NAME = "Orthographic (Two-Hemisphere)";
    public static final int PROPERTIES = 0x2200040;
    private static final double RADIUS_FACTOR = 1.0;

    public Orthographic2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public Orthographic2H(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Orthographic2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x2200040, width, height, xmargin, ymargin, 1.0);
    }

    @Override
    protected double getKForLambdaPPhiP(double lambdaPRad, double phiPRad) {
        return 1.0;
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        return Math.asin(rhoRS * this.invRS_);
    }
}

