/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class NaturalEarth1
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Natural Earth I";
    private static final double A0 = 0.8707;
    private static final double A1 = 1.007226;
    private static final double A2 = -0.131979;
    private static final double A3 = 0.015085;
    private static final double A4 = -0.013791;
    private static final double A7 = -0.044475;
    private static final double A9 = 0.028874;
    private static final double A10 = 0.003971;
    private static final double A11 = -0.005916;
    private static final double A12 = -0.001529;
    private static final double WIDTH_FACTOR = 2.735384723480633;
    private static final double HEIGHT_FACTOR = 1.4224000562099293;

    public NaturalEarth1(int width, int height) {
        this(width, height, 0, 0);
    }

    public NaturalEarth1(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public NaturalEarth1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.735384723480633, 1.4224000562099293);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        if (phiRad == 0.0) {
            x = lambdaRad * 0.8707;
            y = 0.0;
        } else {
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            double phiRad6 = phiRad4 * phiRad2;
            double phiRad8 = phiRad6 * phiRad2;
            double phiRad10 = phiRad8 * phiRad2;
            y = phiRad * (1.007226 + 0.015085 * phiRad2 + -0.044475 * phiRad6 + 0.028874 * phiRad8 + -0.005916 * phiRad10);
            x = lambdaRad == 0.0 ? 0.0 : lambdaRad * (0.8707 + -0.131979 * phiRad2 + -0.013791 * phiRad4 + 0.003971 * phiRad10 + -0.001529 * phiRad10 * phiRad2);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        if (y == 0.0) {
            phiRad = 0.0;
        } else {
            phiRad = this.iterateYOverRSToPhiRad(yOverRS, 1.5707963267948966 * y / this.ymRS_);
            if (Double.isNaN(phiRad)) {
                return null;
            }
        }
        if (x == 0.0) {
            lambdaRad = 0.0;
        } else if (phiRad == 0.0) {
            lambdaRad = x * this.invRS_ / 0.8707;
        } else {
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            double phiRad6 = phiRad4 * phiRad2;
            double phiRad8 = phiRad6 * phiRad2;
            double phiRad10 = phiRad8 * phiRad2;
            lambdaRad = x * this.invRS_ / (0.8707 + -0.131979 * phiRad2 + -0.013791 * phiRad4 + 0.003971 * phiRad10 + -0.001529 * phiRad10 * phiRad2);
            if (Math.abs(lambdaRad) > Math.PI) {
                return null;
            }
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        NaturalEarth1 naturalEarth1 = this;
        synchronized (naturalEarth1) {
            double y;
            double yOverRS;
            double phiRad = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !Double.isNaN(phiRad = this.iterateYOverRSToPhiRad(yOverRS = (y = (double)iy + 0.5) * this.invRS_, phiRad + 1.0E-5)); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double phiRad2 = phiRad * phiRad;
                double phiRad4 = phiRad2 * phiRad2;
                double phiRad6 = phiRad4 * phiRad2;
                double phiRad8 = phiRad6 * phiRad2;
                double phiRad10 = phiRad8 * phiRad2;
                double xFactor = this.invRS_ / (0.8707 + -0.131979 * phiRad2 + -0.013791 * phiRad4 + 0.003971 * phiRad10 + -0.001529 * phiRad10 * phiRad2);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    double lambda = Math.toDegrees(lambdaRad);
                    this.set4SymmetricPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    private double iterateYOverRSToPhiRad(double yOverRS, double firstGuess) {
        boolean found = false;
        double phiRad = firstGuess;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double phiRad6 = phiRad2 * phiRad2 * phiRad2;
            double phiRad8 = phiRad6 * phiRad2;
            double phiRad10 = phiRad8 * phiRad2;
            double a3phiRad2 = 0.015085 * phiRad2;
            double a7phirad6 = -0.044475 * phiRad6;
            double a9phirad8 = 0.028874 * phiRad8;
            double a11phirad10 = -0.005916 * phiRad10;
            double numerator = phiRad * (1.007226 + a3phiRad2 + a7phirad6 + a9phirad8 + a11phirad10) - yOverRS;
            double denominator = 1.007226 + 3.0 * a3phiRad2 + 7.0 * a7phirad6 + 9.0 * a9phirad8 + 11.0 * a11phirad10;
            double dphiRad = -numerator / denominator;
            phiRad += dphiRad;
            if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found || phiRad > 1.5707963267948966) {
            return Double.NaN;
        }
        return phiRad;
    }
}

