/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.map.proj.Interruption;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class McBrydeQ3
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde Q3";
    public static final int PROPERTIES = 0x100000A;
    private static final double JOIN_LAT = 52.15;
    private static final double JOIN_LAT_RAD = Math.toRadians(52.15);
    private static final double YSHIFT = 0.042686;
    private static final double TWO_PLUS_SQRT2 = 3.414213562373095;
    private static final double HALF_TWO_PLUS_SQRT2 = 1.7071067811865475;
    private static final double CONST_FPQ_1 = 3.4641016151377544 / Math.sqrt(3.414213562373095);
    private static final double CONST_FPQ_2 = 1.7320508075688772 * Math.sqrt(3.414213562373095);
    private static final double INV_CONST_FPQ_1 = 1.0 / CONST_FPQ_1;
    private static final double INV_CONST_FPQ_2 = 1.0 / CONST_FPQ_2;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = CONST_FPQ_1 / 1.4142135623730951 - 0.042686;
    private double joinYRS_;

    public McBrydeQ3(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeQ3(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public McBrydeQ3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x100000A, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
        ProjListParameter interrupt = (ProjListParameter)this.getParameter(0);
        interrupt.setDefault(Interruption.CONTINENTS_MCBRYDE.toString());
        interrupt.setValue(Interruption.CONTINENTS_MCBRYDE.toString());
        this.parameterChanged(null);
        this.finishScaling();
    }

    @Override
    protected final void finishScaling() {
        double yy = 2.0 * Math.sin(0.5 * JOIN_LAT_RAD);
        this.joinYRS_ = yy * this.rS_;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double phiRad = Math.toRadians(lat);
        double thetaRad = 0.0;
        if (absLat > 52.15) {
            double phiTerm = 1.7071067811865475 * Math.sin(phiRad);
            thetaRad = phiRad;
            for (int iter = 0; iter < 33; ++iter) {
                double func = Math.sin(0.5 * thetaRad) + Math.sin(thetaRad) - phiTerm;
                double dfunc = 0.5 * Math.cos(0.5 * thetaRad) + Math.cos(thetaRad);
                double dthetaRad = -func / dfunc;
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            y = CONST_FPQ_1 * Math.sin(0.5 * thetaRad);
            y = lat > 0.0 ? (y -= 0.042686) : (y += 0.042686);
        } else {
            y = 2.0 * Math.sin(0.5 * phiRad);
        }
        if (this.isShowingInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double clon = gore[1];
            double dlon = MapUtils.normalizeMP180(lon) - clon;
            if (MapUtils.normalizeMP180(lon) > gore[2]) {
                dlon -= 360.0;
            }
            double dx = Math.toRadians(dlon);
            dx = absLat > 52.15 ? (dx *= (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad)) * INV_CONST_FPQ_2) : (dx *= Math.cos(phiRad) / Math.cos(0.5 * phiRad));
            double cx = this.lonToLambdaRad(clon);
            x = cx + dx;
        } else {
            x = this.lonToLambdaRad(lon);
            x = absLat > 52.15 ? (x *= (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad)) * INV_CONST_FPQ_2) : (x *= Math.cos(phiRad) / Math.cos(0.5 * phiRad));
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.joinYRS_) {
            double yOverRS = Math.abs(y) * this.invRS_ + 0.042686;
            double thetaRad = 2.0 * Math.asin(yOverRS * INV_CONST_FPQ_1);
            phiRad = Math.asin(2.0 * (Math.sin(thetaRad) + Math.sin(0.5 * thetaRad)) / 3.414213562373095);
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = 0.0 - phiRad;
            }
            xFactor = this.invRS_ * CONST_FPQ_2 / (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad));
        } else {
            phiRad = 2.0 * Math.asin(y * 0.5 * this.invRS_);
            xFactor = this.invRS_ * Math.cos(0.5 * phiRad) / Math.cos(phiRad);
        }
        double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        McBrydeQ3 mcBrydeQ3 = this;
        synchronized (mcBrydeQ3) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double xFactor;
                double phiRad;
                double y = (double)iy + 0.5;
                if (Math.abs(y) > this.joinYRS_) {
                    double yOverRS = y * this.invRS_;
                    yOverRS = y > 0.0 ? (yOverRS += 0.042686) : (yOverRS -= 0.042686);
                    double thetaRad = 2.0 * Math.asin(yOverRS * INV_CONST_FPQ_1);
                    phiRad = Math.asin(2.0 * (Math.sin(thetaRad) + Math.sin(0.5 * thetaRad)) / 3.414213562373095);
                    if (phiRad > 1.5707963267948966) break;
                    xFactor = this.invRS_ * CONST_FPQ_2 / (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad));
                } else {
                    phiRad = 2.0 * Math.asin(y * 0.5 * this.invRS_);
                    xFactor = this.invRS_ * Math.cos(0.5 * phiRad) / Math.cos(phiRad);
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

