/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class HillEucyclic
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Hill Eucyclic";
    public static final int PROPERTIES = 512;
    private static final double WIDTH_FACTOR = Math.PI * 4 / Math.sqrt(22.43597501544853);
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double DEFAULT_K = 1.0;
    private ProjDoubleParameter ratioParam_;
    private ProjBooleanParameter northParam_;
    private boolean northOrientation_ = true;
    private double k_;
    private double onePlusK_;
    private double sqrOnePlusK_;
    private double twoOnePlusK_;
    private double beta_;
    private double k2Beta_;
    private double a_;
    private double invA2_;
    private double aRS_;
    private double rho0_;
    private double piPlusFourBetaOnePlusK_;
    private Point2D.Double c2_;
    private final Arc2D.Double arc_ = new Arc2D.Double(0);

    public HillEucyclic(int width, int height) {
        this(width, height, 0, 0);
    }

    public HillEucyclic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public HillEucyclic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 512, width, height, xmargin, ymargin, WIDTH_FACTOR, 1.5707963267948966);
        this.ratioParam_ = new ProjDoubleParameter("Snyder's radial ratio K", "K ratio", "(K\u22650)", 1.0, 0.0, Double.POSITIVE_INFINITY, true, true);
        this.northParam_ = new ProjBooleanParameter("Show oriented to display all of northern hemisphere", "North orientation", true);
        this.addParameter(this.ratioParam_);
        this.addParameter(this.northParam_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        super.parameterChanged(e);
        if (e == null || e.getSource() == null) {
            this.setKRatio(1.0);
            this.setNorthOrientation(true);
        } else if (e.getSource() == this.ratioParam_) {
            this.setKRatio(this.ratioParam_.getValue());
        } else if (e.getSource() == this.northParam_) {
            this.setNorthOrientation(this.northParam_.isSelected());
        }
    }

    public void setKRatio(double k) {
        this.k_ = k;
        this.onePlusK_ = 1.0 + this.k_;
        this.sqrOnePlusK_ = this.onePlusK_ * this.onePlusK_;
        this.twoOnePlusK_ = 2.0 * this.onePlusK_;
        this.beta_ = Math.asin(1.0 / this.onePlusK_);
        this.k2Beta_ = this.k_ * this.k_ * this.beta_;
        this.a_ = 2.0 * Math.sqrt(Math.PI / (Math.PI + 4.0 * this.beta_ * this.onePlusK_));
        this.invA2_ = 1.0 / (this.a_ * this.a_);
        this.rho0_ = 0.5 * this.a_ * (this.onePlusK_ + Math.sqrt(this.k_ * (2.0 + this.k_)));
        this.piPlusFourBetaOnePlusK_ = Math.PI + 4.0 * this.beta_ * this.onePlusK_;
        this.autoscale();
    }

    public void setNorthOrientation(boolean b) {
        this.northOrientation_ = b;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double rho = this.a_ * (this.k_ + 2.0);
        this.setSizeFactors(WIDTH_FACTOR, Math.abs(Math.abs(this.rho0_) - rho));
    }

    @Override
    protected final void finishScaling() {
        this.aRS_ = this.a_ * this.rS_;
        Point2D.Double nBend = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 179.99999, 90.0);
        Point2D.Double sBend = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 179.99999, -90.0);
        this.c2_ = new Point2D.Double(0.5 * (nBend.x + sBend.x), 0.5 * (nBend.y + sBend.y));
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double beta1;
        double rho;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        if (!this.northOrientation_) {
            phiRad = -phiRad;
        }
        if (lat == 90.0) {
            rho = this.a_ * this.k_;
            beta1 = 0.0;
        } else if (lat == -90.0) {
            rho = this.a_ * (this.k_ + 2.0);
            beta1 = 0.0;
        } else {
            double sinTheta;
            double cosTheta;
            double sinPhi = Math.sin(phiRad);
            double lastTerm = 0.5 * (1.0 - sinPhi) * this.piPlusFourBetaOnePlusK_;
            double thetaRad = 1.5707963267948966 - phiRad;
            for (int iter = 0; iter < 33; ++iter) {
                double dfunc;
                double betaPlusBeta1;
                double func;
                double dthetaRad;
                cosTheta = Math.cos(thetaRad);
                if (Math.abs(thetaRad += (dthetaRad = -(func = thetaRad - this.k2Beta_ - this.onePlusK_ * (sinTheta = Math.sin(thetaRad)) + (1.0 + this.sqrOnePlusK_ - this.twoOnePlusK_ * cosTheta) * (betaPlusBeta1 = this.beta_ + (beta1 = Math.atan2(sinTheta, this.onePlusK_ - cosTheta))) - lastTerm) / (dfunc = this.twoOnePlusK_ * sinTheta * betaPlusBeta1))) < 1.0E-5) break;
            }
            cosTheta = Math.cos(thetaRad);
            sinTheta = Math.sin(thetaRad);
            rho = this.a_ * Math.sqrt(1.0 + this.sqrOnePlusK_ - this.twoOnePlusK_ * cosTheta);
            beta1 = Math.atan2(sinTheta, this.onePlusK_ - cosTheta);
        }
        double omegaRad = lambdaRad * (beta1 + this.beta_) * 0.3183098861837907;
        double x = rho * Math.sin(omegaRad);
        double y = this.rho0_ - rho * Math.cos(omegaRad);
        if (!this.northOrientation_) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double rho2OverA2;
        double cosTheta;
        double thetaRad;
        double sinTheta;
        double beta1;
        double betaPlusBeta1;
        double yOverRs;
        double yOverRsMinusRho0;
        double rho2;
        double rho;
        double xOverRs;
        double omegaRad;
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (!this.northOrientation_) {
            y = -y;
        }
        if (Double.isNaN(lambdaRad = (omegaRad = Math.asin((xOverRs = x * this.invRS_) / (rho = Math.sqrt(rho2 = xOverRs * xOverRs + (yOverRsMinusRho0 = (yOverRs = y * this.invRS_) - this.rho0_) * yOverRsMinusRho0)))) * Math.PI / (betaPlusBeta1 = this.beta_ + (beta1 = Math.atan2(sinTheta = Math.sin(thetaRad = Math.acos(cosTheta = (1.0 + this.sqrOnePlusK_ - (rho2OverA2 = rho2 * this.invA2_)) / this.twoOnePlusK_)), this.onePlusK_ - cosTheta)))) || lambdaRad > Math.PI) {
            return null;
        }
        double fleft = thetaRad - this.k2Beta_ - this.onePlusK_ * sinTheta + (1.0 + this.sqrOnePlusK_ - this.twoOnePlusK_ * cosTheta) * betaPlusBeta1;
        double sinPhi = 1.0 - 2.0 * fleft / this.piPlusFourBetaOnePlusK_;
        double phiRad = Math.asin(sinPhi);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        if (!this.northOrientation_) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        HillEucyclic hillEucyclic = this;
        synchronized (hillEucyclic) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                if (!this.northOrientation_) {
                    y = -y;
                }
                double yOverRs = y * this.invRS_;
                double yOverRsMinusRho0 = yOverRs - this.rho0_;
                double sqrYOverRsMinusRho0 = yOverRsMinusRho0 * yOverRsMinusRho0;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double fleft;
                    double sinPhi;
                    double phiRad;
                    double rho2OverA2;
                    double cosTheta;
                    double thetaRad;
                    double sinTheta;
                    double beta1;
                    double betaPlusBeta1;
                    double x = (double)ix + 0.5;
                    double xOverRs = x * this.invRS_;
                    double rho2 = xOverRs * xOverRs + sqrYOverRsMinusRho0;
                    double rho = Math.sqrt(rho2);
                    double omegaRad = Math.acos(-yOverRsMinusRho0 / rho);
                    double lambdaRad = omegaRad * Math.PI / (betaPlusBeta1 = this.beta_ + (beta1 = Math.atan2(sinTheta = Math.sin(thetaRad = Math.acos(cosTheta = (1.0 + this.sqrOnePlusK_ - (rho2OverA2 = rho2 * this.invA2_)) / this.twoOnePlusK_)), this.onePlusK_ - cosTheta)));
                    if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI || Math.abs(phiRad = Math.asin(sinPhi = 1.0 - 2.0 * (fleft = thetaRad - this.k2Beta_ - this.onePlusK_ * sinTheta + (1.0 + this.sqrOnePlusK_ - this.twoOnePlusK_ * cosTheta) * betaPlusBeta1) / this.piPlusFourBetaOnePlusK_)) > 1.5707963267948966) continue;
                    if (this.northOrientation_) {
                        this.set2SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                        continue;
                    }
                    this.set2SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), -Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        this.drawParallel(g2d, 90.0, null);
        this.drawParallel(g2d, -90.0, null);
        double startAngle = Math.toDegrees(this.beta_);
        if (this.northOrientation_) {
            this.arc_.setArcByCenter(this.c2_.x, this.c2_.y, this.aRS_, 270.0 + startAngle, 180.0, 0);
        } else {
            this.arc_.setArcByCenter(this.c2_.x, this.c2_.y, this.aRS_, 90.0 - startAngle, -180.0, 0);
        }
        g2d.draw(this.arc_);
        if (this.northOrientation_) {
            this.arc_.setArcByCenter(2.0 * (double)this.outCenterX_ - this.c2_.x, this.c2_.y, this.aRS_, 90.0 - startAngle, 180.0, 0);
        } else {
            this.arc_.setArcByCenter(2.0 * (double)this.outCenterX_ - this.c2_.x, this.c2_.y, this.aRS_, 270.0 + startAngle, -180.0, 0);
        }
        g2d.draw(this.arc_);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double lon1 = this.lambdaC_ + -179.99999;
        double lon2 = this.lambdaC_;
        double lon3 = this.lambdaC_ + 179.99999;
        Point2D.Double dot1 = this.transformLL2XY(lon1, lat);
        Point2D.Double dot2 = this.transformLL2XY(lon2, lat);
        Point2D.Double dot3 = this.transformLL2XY(lon3, lat);
        if (this.k_ < 5000.0) {
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        } else {
            GraphicUtils.drawLine(g2d, dot1, dot3);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

