/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import java.awt.Dimension;

public class Ginzburg1
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Ginzburg I";
    private static final double CONST_A = 6.6E-4;
    private static final double CONST_Q = 9.0;
    private static final double AQ = 0.00594;
    private static final double Q_MINUS_1 = 8.0;
    private static final double DEFAULT_RADIUS = 90.0;
    private static final double MAX_RADIUS = 90.0;

    public Ginzburg1(int width, int height) {
        this(width, height, 0, 0);
    }

    public Ginzburg1(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Ginzburg1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeRadiusParameter(90.0, 90.0, true);
        this.addFillParameter();
        this.parameterChanged(null);
    }

    @Override
    public void setEdgeRadius(double r) {
        this.radiusDeg_ = r;
        this.radiusRad_ = Math.toRadians(this.radiusDeg_);
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double rhoMaxOverR = 2.0 * Math.sin(0.5 * this.radiusRad_) + 6.6E-4 * Math.pow(this.radiusRad_, 9.0);
        this.setSizeFactor(rhoMaxOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double rhoBOverR = 1.4142135623730951 + 6.6E-4 * Math.pow(1.5707963267948966, 9.0);
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        double z = Math.acos(cosZ);
        double rho = 2.0 * Math.sin(0.5 * z) + 6.6E-4 * Math.pow(z, 9.0);
        double rho2 = rho * rho;
        if (rho2 * this.r2s2_ > this.rhoBorder2_) {
            return -1.0;
        }
        return rho / Math.sin(z);
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        double rho = rhoRS / this.rS_;
        double z = rho * 1.5707963267948966;
        for (int iter = 0; iter < 33; ++iter) {
            double halfZ = 0.5 * z;
            double sinHalfZ = Math.sin(halfZ);
            double cosHalfZ = Math.cos(halfZ);
            double func = 2.0 * sinHalfZ + 6.6E-4 * Math.pow(z, 9.0) - rho;
            double dfunc = cosHalfZ + 0.00594 * Math.pow(z, 8.0);
            double dz = -func / dfunc;
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }
}

