/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class ErdiKrausz
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "\u00c9rdi-Krausz";
    public static final int PROPERTIES = 10;
    private static final double JOIN_LAT = 60.0;
    private static final double JOIN_LAT_RAD = Math.toRadians(60.0);
    private static final double CXE = 0.96042;
    private static final double CYE = 1.30152;
    private static final double CXP = 1.07023;
    private static final double CYP = 1.68111;
    private static final double YSHIFT = 0.28549;
    private static final double WIDTH_FACTOR = 3.0172484163607094;
    private static final double HEIGHT_FACTOR = 1.39562;
    private double joinYRS_;

    public ErdiKrausz(int width, int height) {
        this(width, height, 0, 0);
    }

    public ErdiKrausz(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public ErdiKrausz(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 10, width, height, xmargin, ymargin, 3.0172484163607094, 1.39562);
        this.autoscale();
    }

    @Override
    protected final void finishScaling() {
        double yy = 1.30152 * Math.asin(0.8 * Math.sin(JOIN_LAT_RAD));
        this.joinYRS_ = yy * this.rS_;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        if (lat == 90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - 1.39562 * this.rS_);
        }
        if (lat == -90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + 1.39562 * this.rS_);
        }
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double x = this.lonToLambdaRad(lon);
        if (absLat > 60.0) {
            double piSinPhi = Math.PI * sinPhi;
            double thetaRad = Math.toRadians(lat);
            for (int iter = 0; iter < 33; ++iter) {
                double twoThetaRad = 2.0 * thetaRad;
                double func = twoThetaRad + Math.sin(twoThetaRad) - piSinPhi;
                double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
                double dthetaRad = -func / dfunc;
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            x *= 1.07023 * Math.cos(thetaRad);
            y = 1.68111 * Math.sin(thetaRad);
            y = lat > 0.0 ? (y -= 0.28549) : (y += 0.28549);
        } else {
            double thetaRad = Math.asin(0.8 * sinPhi);
            x *= 0.96042 * Math.cos(thetaRad);
            y = 1.30152 * thetaRad;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = 0.0;
        double xFactor = 0.0;
        if (Math.abs(y) > this.joinYRS_) {
            double sinTheta = (Math.abs(y) * this.invRS_ + 0.28549) / 1.68111;
            double thetaRad = Math.asin(sinTheta);
            phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
            xFactor = this.invRS_ / (1.07023 * Math.cos(thetaRad));
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = 0.0 - phiRad;
            }
        } else {
            double thetaRad = y * this.invRS_ / 1.30152;
            phiRad = Math.asin(Math.sin(thetaRad) / 0.8);
            xFactor = this.invRS_ / (0.96042 * Math.cos(thetaRad));
        }
        double lambdaRad = x * xFactor;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        ErdiKrausz erdiKrausz = this;
        synchronized (erdiKrausz) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double xFactor;
                double phiRad;
                double thetaRad;
                double y = (double)iy + 0.5;
                if (y > this.joinYRS_) {
                    double sinTheta = (y += 0.28549 * this.rS_) * this.invRS_ / 1.68111;
                    thetaRad = Math.asin(sinTheta);
                    phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
                    xFactor = this.invRS_ / (1.07023 * Math.cos(thetaRad));
                    if (phiRad > 1.5707963267948966) {
                        break;
                    }
                } else {
                    thetaRad = y * this.invRS_ / 1.30152;
                    phiRad = Math.asin(Math.sin(thetaRad) / 0.8);
                    xFactor = this.invRS_ / (0.96042 * Math.cos(thetaRad));
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

