/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bottomley
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Bottomley";
    public static final int PROPERTIES = 0;
    private static final double WIDTH_FACTOR = 3.5342917352885173;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double DEFAULT_PHI1 = 30.0;
    private double phi1_ = 30.0;
    private double sinPhi1_;
    private double invSinPhi1_;
    private double yshift_;
    private double lobeTipLat_;
    private ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude of reference parallel", "Reference Lat.", "\u00b0N", 30.0, 0.0, 90.0, true, true);

    public Bottomley(int width, int height) {
        this(width, height, 0, 0);
    }

    public Bottomley(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Bottomley(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0, width, height, xmargin, ymargin, 3.5342917352885173, 1.5707963267948966);
        this.addParameter(this.phi1Param_);
        this.autoscale();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p != null && p != this.phi1Param_) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setReferenceParallel(this.phi1Param_.getValue());
    }

    public void setReferenceParallel(double lat) {
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Reference latitude out of valid range");
        }
        if (lat < 0.0) {
            LOGGER.debug("Reference lat < 0. Re-setting to positive.");
        }
        this.phi1_ = absLat;
        double phi1Rad = Math.toRadians(this.phi1_);
        this.sinPhi1_ = Math.sin(phi1Rad);
        this.invSinPhi1_ = this.sinPhi1_ > 0.0 ? 1.0 / this.sinPhi1_ : 1000000.0;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double widthFactor;
        double yy = 1.5707963267948966;
        if (this.phi1_ == 0.0) {
            widthFactor = Math.PI;
        } else {
            double latX = this.latitudeOfMaxX();
            double phiRad = Math.toRadians(latX);
            double alphaRad = 1.5707963267948966 - phiRad;
            double sinAlpha = Math.sin(alphaRad);
            double betaRad = Math.PI * this.sinPhi1_ * sinAlpha / alphaRad;
            double sinBeta = Math.sin(betaRad);
            widthFactor = alphaRad * sinBeta * this.invSinPhi1_;
        }
        if (Math.abs(this.phi1_) > 30.0) {
            this.lobeTipLat_ = this.latitudeOfLobeMaxY();
            if (Double.isNaN(this.lobeTipLat_)) {
                this.lobeTipLat_ = 0.0;
            } else {
                double phiRad = Math.toRadians(this.lobeTipLat_);
                double alphaRad = 1.5707963267948966 - phiRad;
                double betaRad = Math.PI * this.sinPhi1_ * Math.sin(alphaRad) / alphaRad;
                yy = 1.5707963267948966 - alphaRad * Math.cos(betaRad);
            }
        } else {
            this.lobeTipLat_ = 0.0;
        }
        this.yshift_ = -0.5 * (yy - 1.5707963267948966);
        double heightFactor = 0.5 * (yy + 1.5707963267948966);
        this.setSizeFactors(widthFactor, heightFactor);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambda = this.lonToLambda(lon);
        double lambdaRad = Math.toRadians(lambda);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        if (this.phi1_ == 0.0) {
            x = lambdaRad * cosPhi;
            y = phiRad;
        } else if (lambdaRad == 0.0 || Math.abs(phiRad) == 1.5707963267948966) {
            x = 0.0;
            y = phiRad;
        } else {
            double alphaRad = 1.5707963267948966 - phiRad;
            double sinAlpha = Math.sin(alphaRad);
            double betaRad = lambdaRad * this.sinPhi1_ * sinAlpha / alphaRad;
            double cosBeta = Math.cos(betaRad);
            double sinBeta = Math.sin(betaRad);
            x = alphaRad * sinBeta * this.invSinPhi1_;
            y = 1.5707963267948966 - alphaRad * cosBeta;
        }
        y += this.yshift_;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        if (Math.abs(x) > (double)this.dxMax_) {
            return null;
        }
        double y = (double)this.outCenterY_ - yy - this.yshift_;
        if (Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_ - this.yshift_;
        if (this.phi1_ == 0.0) {
            phiRad = yOverRS;
            lambdaRad = xOverRS == 0.0 ? 0.0 : xOverRS / Math.cos(phiRad);
        } else if (xOverRS == 0.0) {
            phiRad = yOverRS;
            lambdaRad = 0.0;
        } else {
            double halfPiMinusY = 1.5707963267948966 - yOverRS;
            double alphaRad = Math.hypot(xOverRS * this.sinPhi1_, halfPiMinusY);
            phiRad = 1.5707963267948966 - alphaRad;
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            double betaRad = Math.atan2(xOverRS * this.sinPhi1_, halfPiMinusY);
            lambdaRad = betaRad * alphaRad / (Math.sin(alphaRad) * this.sinPhi1_);
        }
        if (Math.abs(lambdaRad) > Math.PI || Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Bottomley bottomley = this;
        synchronized (bottomley) {
            double cosPhi = 0.0;
            block3: for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double phiRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - this.yshift_;
                if (this.phi1_ == 0.0) {
                    phiRad = yOverRS;
                    cosPhi = Math.cos(yOverRS);
                }
                double halfPiMinusY = 1.5707963267948966 - yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    if (this.phi1_ == 0.0) {
                        phiRad = yOverRS;
                        lambdaRad = xOverRS / cosPhi;
                    } else {
                        double alphaRad = Math.hypot(xOverRS * this.sinPhi1_, halfPiMinusY);
                        phiRad = 1.5707963267948966 - alphaRad;
                        if (Math.abs(phiRad) > 1.5707963267948966) continue;
                        double betaRad = Math.atan2(xOverRS * this.sinPhi1_, halfPiMinusY);
                        lambdaRad = betaRad * alphaRad / (Math.sin(alphaRad) * this.sinPhi1_);
                    }
                    if (lambdaRad > Math.PI) {
                        if (!(Math.abs(this.phi1_) < 30.0)) continue;
                        continue block3;
                    }
                    this.set2SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier bcurve = this.makeBezier(this.lambdaC_ + 179.99999);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeBezier(this.lambdaC_ - 179.99999)) != null) {
            bcurve.draw(g2d);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        Bezier bcurve = this.makeBezier(lon);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
    }

    private Bezier makeBezier(double lon) {
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(100);
        double lat = -90.0;
        while (lat <= 90.0) {
            Point2D.Double dot = this.transformLL2XY(lon, lat);
            if (dot == null) {
                return new Bezier(false, ptlist);
            }
            ptlist.add(new Point2D.Double(dot.x, dot.y));
            double nextlat = 0.0;
            nextlat = Math.abs(lat) >= 85.0 ? lat + 0.2 : lat + 1.0;
            if (lat < 90.0 && nextlat > 90.0) {
                nextlat = 90.0;
            }
            lat = nextlat;
        }
        return new Bezier(false, ptlist);
    }

    private double latitudeOfMaxX() {
        if (this.phi1_ == 0.0) {
            return 0.0;
        }
        double phiRad = -Math.toRadians(0.4 * this.phi1_);
        for (int iter = 0; iter < 33; ++iter) {
            double alphaRad = 1.5707963267948966 - phiRad;
            double sinAlpha = Math.sin(alphaRad);
            double cosAlpha = Math.cos(alphaRad);
            double betaRad = Math.PI * this.sinPhi1_ * sinAlpha / alphaRad;
            double sinBeta = Math.sin(betaRad);
            double cosBeta = Math.cos(betaRad);
            double dbetaRad = -(Math.PI * this.sinPhi1_ * cosAlpha - betaRad) / alphaRad;
            double dsinBeta = cosBeta * dbetaRad;
            double dcosBeta = -sinBeta * dbetaRad;
            double d2betaRad = -Math.PI * this.sinPhi1_ * sinAlpha / alphaRad;
            double func = -sinBeta + alphaRad * dsinBeta;
            double dfunc = alphaRad * dcosBeta * dbetaRad + alphaRad * cosBeta * d2betaRad;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return Math.toDegrees(phiRad);
    }

    private double latitudeOfLobeMaxY() {
        if (Math.abs(this.phi1_) <= 30.0) {
            return Double.NaN;
        }
        double phiRad = Math.toRadians(90.0 - 0.7 * this.phi1_);
        if (this.phi1_ < 0.0) {
            phiRad = -phiRad;
        }
        for (int iter = 0; iter < 33; ++iter) {
            double alphaRad = 1.5707963267948966 - phiRad;
            double sinAlpha = Math.sin(alphaRad);
            double cosAlpha = Math.cos(alphaRad);
            double betaRad = Math.PI * this.sinPhi1_ * sinAlpha / alphaRad;
            double sinBeta = Math.sin(betaRad);
            double cosBeta = Math.cos(betaRad);
            double dbetaRad = -(Math.PI * this.sinPhi1_ * cosAlpha - betaRad) / alphaRad;
            double dsinBeta = cosBeta * dbetaRad;
            double dcosBeta = -sinBeta * dbetaRad;
            double d2betaRad = -Math.PI * this.sinPhi1_ * sinAlpha / alphaRad;
            double func = cosBeta - alphaRad * dcosBeta;
            double dfunc = alphaRad * dsinBeta * dbetaRad + alphaRad * sinBeta * d2betaRad;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return Math.toDegrees(phiRad);
    }
}

