/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzimuthalProjection
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int PROPERTIES = 0x200040;
    protected static final double MIN_RADIUS = 1.0E-4;
    protected double rhoBorder_;
    protected double rhoBorder2_;
    private final Arc2D.Double arc_ = new Arc2D.Double();
    protected double cosPhiC_;
    protected double sinPhiC_;
    protected ProjDoubleParameter edgeParam_;
    protected ProjBooleanParameter fillParam_;
    protected double radiusDeg_ = 15.0;
    protected double radiusRad_;
    protected boolean fillCorners_;

    public AzimuthalProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
        this.setCenter(this.lambdaC_, this.phiC_);
    }

    protected void addEdgeRadiusParameter(double value, double maxRadius, boolean maxAllowed) {
        StringBuilder unitsSB = new StringBuilder("\u00b0 (");
        if (maxAllowed) {
            unitsSB.append("\u2264");
        } else {
            unitsSB.append("<");
        }
        unitsSB.append(maxRadius).append("\u00b0)");
        this.edgeParam_ = new ProjDoubleParameter("Angle between center and nearest edge of map", "Edge Radius", unitsSB.toString(), value, 1.0E-4, maxRadius, true, maxAllowed);
        this.addParameter(this.edgeParam_);
    }

    public ProjDoubleParameter getEdgeRadiusParameter() {
        return this.edgeParam_;
    }

    protected void addFillParameter() {
        this.fillParam_ = new ProjBooleanParameter("Map is not limited to purely circular area", "Fill corners", true);
        this.addParameter(this.fillParam_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            if (this.edgeParam_ != null) {
                this.setEdgeRadius(this.edgeParam_.getValue());
            }
            if (this.fillParam_ != null) {
                this.setFillCorners(this.fillParam_.isSelected());
            }
        } else if (p == this.edgeParam_) {
            this.setEdgeRadius(this.edgeParam_.getValue());
        } else if (p == this.fillParam_) {
            this.setFillCorners(this.fillParam_.isSelected());
        } else {
            LOGGER.trace("Param not handled by AzimuthalProjection");
        }
    }

    public abstract void setEdgeRadius(double var1);

    public void setFillCorners(boolean fill) {
        this.fillCorners_ = fill;
        this.autoscale();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.cosPhiC_ = Math.cos(this.phiCRad_);
        this.sinPhiC_ = Math.sin(this.phiCRad_);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ == -1.0) {
            return null;
        }
        if (cosZ == 1.0) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double k = this.getKForCosZ(cosZ);
        if (k < 0.0) {
            return null;
        }
        double x = k * cosPhi * Math.sin(lambdaRad);
        double rho2 = x * x + (y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda)) * y;
        if (rho2 * this.r2s2_ > this.rhoBorder2_) {
            return null;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    protected abstract double getKForCosZ(double var1);

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        if (!this.isWithinMargins(xx, yy)) {
            return null;
        }
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double z = this.getZForRhoRS(rho);
        if (Double.isNaN(z)) {
            return null;
        }
        double[] lambdaPhi = this.calculateLambdaPhiFromXYRhoZ(x, y, rho, z);
        if (lambdaPhi == null) {
            return null;
        }
        double lambdaRad = lambdaPhi[0];
        double phiRad = lambdaPhi[1];
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AzimuthalProjection azimuthalProjection = this;
        synchronized (azimuthalProjection) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double y2 = y * y;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double z;
                    double rho;
                    double[] lambdaPhi;
                    double x = (double)ix + 0.5;
                    double rho2 = x * x + y2;
                    if (rho2 > this.rhoBorder2_ || (lambdaPhi = this.calculateLambdaPhiFromXYRhoZ(x, y, rho = Math.sqrt(rho2), z = this.getZForRhoRS(rho))) == null) continue;
                    double lambdaRad = lambdaPhi[0];
                    double phiRad = lambdaPhi[1];
                    this.set2SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    protected abstract double getZForRhoRS(double var1);

    protected double[] calculateLambdaPhiFromXYRhoZ(double x, double y, double rho, double z) {
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
        return new double[]{lambdaRad, phiRad};
    }

    @Override
    public LonLatBounds getBounds() {
        double dlon2;
        double lat;
        PointLL ll;
        int j;
        LOGGER.trace("lonC {}, latC {}, r {}", this.lambdaC_, this.phiC_, this.radiusDeg_);
        double wOver2 = 0.5 * (double)this.outWidth_;
        double hOver2 = 0.5 * (double)this.outHeight_;
        double dlon = 0.0;
        double tLat = -9999.0;
        double bLat = 9999.0;
        if (this.transformLL2XY(0.0, 90.0) != null) {
            tLat = 90.0;
            dlon = 180.0;
        }
        if (this.transformLL2XY(0.0, -90.0) != null) {
            bLat = -90.0;
            dlon = 180.0;
        }
        int j1 = 0;
        int j2 = this.outHeight_ - 1;
        for (j = 0; j < this.outHeight_; ++j) {
            ll = this.transformXY2LL(wOver2, (double)j + 0.5);
            if (ll == null) continue;
            lat = ll.getLat();
            tLat = Math.max(tLat, lat);
            bLat = Math.min(bLat, lat);
            j1 = j;
            break;
        }
        for (j = this.outHeight_ - 1; j > j1 && j > 0; --j) {
            ll = this.transformXY2LL(wOver2, (double)j + 0.5);
            if (ll == null) continue;
            lat = ll.getLat();
            tLat = Math.max(tLat, lat);
            bLat = Math.min(bLat, lat);
            j2 = j;
            break;
        }
        if (dlon < 180.0 && tLat < 90.0 && bLat > -90.0) {
            double r = Math.abs((double)j1 - hOver2);
            for (int i = 5; i < 90; i += 5) {
                double rCos = r * Math.cos(Math.toRadians(i));
                double rSin = r * Math.sin(Math.toRadians(i));
                PointLL ll1 = this.transformXY2LL(wOver2 + rCos - 1.0, hOver2 + rSin - 1.0);
                PointLL ll2 = this.transformXY2LL(wOver2 - rCos + 1.0, hOver2 - rSin + 1.0);
                double dlon1 = ll1 == null ? 0.0 : (this.lambdaC_ > ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() + 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon()));
                dlon2 = ll2 == null ? 0.0 : (this.lambdaC_ < ll2.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll2.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll2.getLon()));
                dlon = Math.max(Math.max(dlon, dlon1), dlon2);
            }
        }
        int i = 0;
        while ((double)i < wOver2) {
            double lat2;
            double dlon1;
            PointLL ll1 = this.transformXY2LL(wOver2 + (double)i, (double)j1 + 0.5);
            PointLL ll2 = this.transformXY2LL(wOver2 + (double)i, (double)j2 + 0.5);
            if (ll1 == null && ll2 == null) break;
            if (ll1 == null) {
                dlon1 = 0.0;
            } else {
                lat2 = ll1.getLat();
                tLat = Math.max(tLat, lat2);
                bLat = Math.min(bLat, lat2);
                dlon1 = this.lambdaC_ > ll1.getLon() ? 1.01 * Math.abs(this.lambdaC_ - (ll1.getLon() + 360.0)) : 1.01 * Math.abs(this.lambdaC_ - ll1.getLon());
            }
            if (ll2 == null) {
                dlon2 = 0.0;
            } else {
                lat2 = ll2.getLat();
                tLat = Math.max(tLat, lat2);
                bLat = Math.min(bLat, lat2);
                dlon2 = this.lambdaC_ > ll2.getLon() ? 1.01 * Math.abs(this.lambdaC_ - (ll2.getLon() + 360.0)) : 1.01 * Math.abs(this.lambdaC_ - ll2.getLon());
            }
            dlon = Math.max(Math.max(dlon, dlon1), dlon2);
            ++i;
        }
        double dlat = Math.max(Math.abs(this.phiC_ - tLat), Math.abs(this.phiC_ - bLat));
        double llTop = Math.min(90.0, tLat);
        double llBottom = Math.max(-90.0, bLat);
        if (tLat > 89.5 || bLat < -89.5 || dlon > 180.0) {
            dlon = 180.0;
        } else {
            PointLL ll1;
            dlon = Math.max(dlon, dlat);
            int i1 = 0;
            int i2 = 0;
            while ((double)i2 < wOver2) {
                ll1 = this.transformXY2LL((double)i2, hOver2);
                if (ll1 != null) {
                    double dlon1 = this.lambdaC_ < ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon());
                    dlon = Math.max(dlon, dlon1);
                    i1 = i2;
                    break;
                }
                ++i2;
            }
            int j3 = 0;
            while ((double)j3 < hOver2) {
                ll1 = this.transformXY2LL((double)i1, hOver2 - (double)j3 + 0.5);
                PointLL ll2 = this.transformXY2LL((double)i1, hOver2 + (double)j3 + 0.5);
                if (ll1 == null && ll2 == null) break;
                double dlon1 = ll1 == null ? 0.0 : (this.lambdaC_ < ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon()));
                dlon2 = ll2 == null ? 0.0 : (this.lambdaC_ < ll2.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll2.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll2.getLon()));
                dlon = Math.max(Math.max(dlon, dlon1), dlon2);
                ++j3;
            }
        }
        double llLeft = this.lambdaC_ - dlon;
        double llRight = this.lambdaC_ + dlon;
        if (llRight - llLeft > 300.0) {
            llLeft = -180.0;
            llRight = 180.0;
        } else if (llLeft < -180.0) {
            llLeft += 360.0;
            llRight += 360.0;
        }
        if (Math.abs(llTop) > 9000.0 || Math.abs(llBottom) > 9000.0) {
            llTop = 90.0;
            llBottom = -90.0;
        } else if (llTop < llBottom) {
            double temp = llTop;
            llTop = llBottom;
            llBottom = temp;
        }
        LonLatBounds result = new LonLatBounds(llLeft, llTop, llRight, llBottom);
        LOGGER.trace("bounds {}", (Object)result);
        return result;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        this.drawCircle(g2d, this.rhoBorder_, true);
    }

    private void drawCircle(Graphics2D g2d, double radius, boolean link) {
        double r2 = radius * radius;
        double w2 = this.dxMax_ * this.dxMax_;
        double h2 = this.dyMax_ * this.dyMax_;
        double rhoCorner = Math.sqrt(w2 + h2);
        g2d.translate(this.outCenterX_, this.outCenterY_);
        if (radius <= (double)this.dxMax_ && radius <= (double)this.dyMax_) {
            ProjectionUtils.drawEllipse(g2d, 0.0, 0.0, radius, radius);
        } else if (radius > rhoCorner) {
            if (link) {
                ProjectionUtils.drawRect(g2d, -this.dxMax_, -this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
            }
        } else if (radius > (double)this.dxMax_ && radius > (double)this.dyMax_) {
            double dxx = Math.sqrt(r2 - h2);
            double dyy = Math.sqrt(r2 - w2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-dxx, -this.dyMax_);
                path.lineTo(dxx, -this.dyMax_);
                path.moveTo(this.dxMax_, -dyy);
                path.lineTo(this.dxMax_, dyy);
                path.moveTo(dxx, this.dyMax_);
                path.lineTo(-dxx, this.dyMax_);
                path.moveTo(-this.dxMax_, dyy);
                path.lineTo(-this.dxMax_, -dyy);
                g2d.draw(path);
            }
            double angle1 = -Math.toDegrees(Math.acos(dxx / radius));
            double angle2 = 90.0 - Math.toDegrees(Math.acos(dyy / radius));
            double arc = Math.abs(angle1 + angle2);
            this.arc_.setArcByCenter(0.0, 0.0, radius, angle1, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, -angle1, -arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 + angle1, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 - angle1, -arc, 0);
            g2d.draw(this.arc_);
        } else if (radius > (double)this.dyMax_) {
            double dxx = Math.sqrt(r2 - h2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-dxx, -this.dyMax_);
                path.lineTo(dxx, -this.dyMax_);
                path.moveTo(dxx, this.dyMax_);
                path.lineTo(-dxx, this.dyMax_);
                g2d.draw(path);
            }
            double angle = -Math.toDegrees(Math.acos(dxx / radius));
            double arc = -2.0 * angle;
            this.arc_.setArcByCenter(0.0, 0.0, radius, angle, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 + angle, arc, 0);
            g2d.draw(this.arc_);
        } else if (radius > (double)this.dxMax_) {
            double dyy = Math.sqrt(r2 - w2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-this.dxMax_, -dyy);
                path.lineTo(-this.dxMax_, dyy);
                path.moveTo(this.dxMax_, dyy);
                path.lineTo(this.dxMax_, -dyy);
                g2d.draw(path);
            }
            double angle = 90.0 - Math.toDegrees(Math.acos(dyy / radius));
            double arc = 180.0 - 2.0 * angle;
            this.arc_.setArcByCenter(0.0, 0.0, radius, angle, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 + angle, arc, 0);
            g2d.draw(this.arc_);
        }
        g2d.translate(-this.outCenterX_, -this.outCenterY_);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(this.phiC_) > 89.99999) {
            boolean skip;
            double dlat = Math.abs(this.phiC_ - lat);
            boolean bl = skip = !this.fillCorners_ && dlat >= this.radiusDeg_;
            if (skip) {
                return;
            }
            Point2D.Double dot = this.transformLL2XYIgnoreMargins(this.lambdaC_, lat);
            if (dot == null) {
                return;
            }
            double r = Math.abs((double)this.outCenterY_ - dot.y);
            this.drawCircle(g2d, r, false);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        if (Math.abs(this.phiC_) > 89.99999) {
            Point2D.Double dot;
            Point2D.Double double_ = dot = this.phiC_ > 0.0 ? this.transformLL2XYIgnoreMargins(lon, 85.0) : this.transformLL2XYIgnoreMargins(lon, -85.0);
            if (dot == null) {
                return;
            }
            double dx = dot.x - (double)this.outCenterX_;
            double dy = dot.y - (double)this.outCenterY_;
            double r = Math.hypot(dx, dy);
            double ratio = this.rhoBorder_ / r;
            dx *= ratio;
            dy *= ratio;
            if (Math.abs(dx) > (double)this.dxMax_) {
                ratio = Math.abs((double)this.dxMax_ / dx);
                dx *= ratio;
                dy *= ratio;
            }
            if (Math.abs(dy) > (double)this.dyMax_) {
                ratio = Math.abs((double)this.dyMax_ / dy);
                dx *= ratio;
                dy *= ratio;
            }
            GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterY_, (double)this.outCenterX_ + dx, (double)this.outCenterY_ + dy);
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

