/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.kml;

import gov.nasa.giss.util.EasyXmlParser;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMLData {
    private static final Logger LOGGER = LoggerFactory.getLogger(KMLData.class);
    private static final String KML_EXT = "kml";
    private static final String KMZ_EXT = "kmz";
    private static final String DOT_KML = ".kml";
    private static final String DOT_KMZ = ".kmz";
    private boolean parsed_;
    private final Object address_;
    private final boolean rootIsKMZ_;
    private String name_;
    private double north_ = Double.NaN;
    private double east_ = Double.NaN;
    private double south_ = Double.NaN;
    private double west_ = Double.NaN;
    private double rotation_ = Double.NaN;
    private String imageHREF_;
    private BufferedImage image_;

    public KMLData(File ff) {
        this.address_ = ff;
        this.name_ = ff.getName();
        this.rootIsKMZ_ = this.name_.toLowerCase().endsWith(DOT_KMZ);
    }

    public KMLData(URL url) {
        int lastSlash;
        this.address_ = url;
        String ss = url.toString();
        if (ss.startsWith("jar:file:") && (lastSlash = ss.lastIndexOf(47)) > 0) {
            this.name_ = ss.substring(lastSlash + 1);
        }
        if (this.name_ == null) {
            this.name_ = url.getFile();
        }
        this.rootIsKMZ_ = this.name_.toLowerCase().endsWith(DOT_KMZ);
    }

    public void parse() throws IOException, JDOMException, ParseException {
        if (this.parsed_) {
            return;
        }
        if (this.rootIsKMZ_) {
            if (this.address_ instanceof File) {
                ZipFile zf = new ZipFile((File)this.address_);
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry ze = entries.nextElement();
                    String lcname = ze.getName().toLowerCase();
                    if (!lcname.endsWith(DOT_KML)) continue;
                    try (InputStream zeStream = zf.getInputStream(ze);){
                        this.parseKml(zeStream);
                        break;
                    }
                }
            } else if (this.address_ instanceof URL) {
                try (InputStream istream = ((URL)this.address_).openStream();
                     ZipInputStream zstream = new ZipInputStream(istream);){
                    ZipEntry ze = zstream.getNextEntry();
                    while (ze != null) {
                        String zename = ze.getName();
                        String lcname = zename.toLowerCase();
                        if (lcname.endsWith(DOT_KML)) {
                            byte[] bytes = this.readZipEntryBytes(zstream, ze);
                            try (ByteArrayInputStream zeStream = new ByteArrayInputStream(bytes);){
                                this.parseKml(zeStream);
                            }
                        }
                        ze = zstream.getNextEntry();
                    }
                }
            }
        } else if (this.address_ instanceof File) {
            try (FileInputStream fstream = new FileInputStream((File)this.address_);){
                this.parseKml(fstream);
            }
        } else if (this.address_ instanceof URL) {
            try (InputStream istream = ((URL)this.address_).openStream();){
                this.parseKml(istream);
            }
        }
        this.parsed_ = true;
    }

    private void parseKml(InputStream istream) throws IOException, JDOMException, ParseException {
        Document doc = EasyXmlParser.parseDocument(istream);
        Element root = doc.getRootElement();
        this.parseElement(root);
        if (this.imageHREF_ == null) {
            throw new ParseException("No GroundOverlay tag found in KML file", 0);
        }
    }

    private void parseElement(Element elem) throws ParseException {
        if (this.imageHREF_ != null) {
            return;
        }
        for (Element child : elem.getChildren()) {
            String childName = child.getName();
            if ("GroundOverlay".equals(childName)) {
                this.parseGroundOverlay(child);
                return;
            }
            if (!"Folder".equals(childName) && !"Document".equals(childName)) continue;
            this.parseElement(child);
        }
    }

    private void parseGroundOverlay(Element go) throws ParseException {
        Element box = null;
        Element icon = null;
        for (Element child : go.getChildren()) {
            String childName = child.getName();
            if ("Icon".equals(childName)) {
                icon = child;
                continue;
            }
            if (!"LatLonBox".equals(childName)) continue;
            box = child;
        }
        if (icon == null) {
            throw new ParseException("No Icon tag found in KML file", 0);
        }
        if (box == null) {
            throw new ParseException("No LatLonBox tag found in KML file", 0);
        }
        for (Element child : icon.getChildren()) {
            String childName = child.getName();
            if (!"href".equals(childName)) continue;
            this.imageHREF_ = child.getText();
        }
        for (Element child : box.getChildren()) {
            String childName = child.getName();
            if ("north".equals(childName)) {
                this.north_ = Double.parseDouble(child.getText());
                continue;
            }
            if ("east".equals(childName)) {
                this.east_ = Double.parseDouble(child.getText());
                continue;
            }
            if ("south".equals(childName)) {
                this.south_ = Double.parseDouble(child.getText());
                continue;
            }
            if ("west".equals(childName)) {
                this.west_ = Double.parseDouble(child.getText());
                continue;
            }
            if (!"rotation".equals(childName)) continue;
            this.rotation_ = Double.parseDouble(child.getText());
        }
    }

    public BufferedImage getGroundOverlayImage() throws IOException {
        block3: {
            try {
                if (this.image_ == null) {
                    this.loadGroundOverlayImage();
                }
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block3;
                exc.printStackTrace();
            }
        }
        return this.image_;
    }

    /*
     * Exception decompiling
     */
    private BufferedImage loadGroundOverlayImage() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] readZipEntryBytes(ZipInputStream zin, ZipEntry ze) throws IOException {
        byte[] bytes;
        block15: {
            block14: {
                int chunksize;
                long zesize = ze.getSize();
                bytes = null;
                if (zesize <= 0L) break block14;
                bytes = new byte[(int)zesize];
                int nread = zin.read(bytes);
                if ((long)nread >= zesize) break block15;
                int offset = nread;
                while ((long)offset < zesize && (nread = zin.read(bytes, offset, chunksize = Math.min(160000, (int)(zesize - (long)offset)))) != chunksize && nread >= 0) {
                    offset += nread;
                }
                break block15;
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int chunksize;
                byte[] buffer = new byte[160000];
                while ((chunksize = zin.read(buffer)) >= 0) {
                    baos.write(buffer, 0, chunksize);
                }
                bytes = baos.toByteArray();
            }
        }
        return bytes;
    }

    public void flush() {
        this.image_ = null;
    }

    public double[] getBounds() {
        return new double[]{this.east_, this.north_, this.west_, this.south_};
    }

    public double getWest() {
        return this.west_;
    }

    public double getNorth() {
        return this.north_;
    }

    public double getEast() {
        return this.east_;
    }

    public double getSouth() {
        return this.south_;
    }

    public double getRotation() {
        return this.rotation_;
    }

    public String toString() {
        return this.name_;
    }
}

