/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public final class TiffUtils {
    public static boolean isSupportedByImageIO() {
        String[] sfxs;
        for (String sfx : sfxs = ImageIO.getReaderFileSuffixes()) {
            if (!sfx.equalsIgnoreCase("tif") && !sfx.equalsIgnoreCase("tiff")) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static Dimension getImageDimensions(File f) throws FileNotFoundException, IOException, UnsupportedOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Dimension getImageDimensions(DataInputStream dis) throws FileNotFoundException, IOException, UnsupportedOperationException {
        boolean bigEndian = true;
        boolean good = true;
        byte[] bb = new byte[4];
        dis.read(bb);
        if (bb[0] == 77 && bb[1] == 77) {
            bigEndian = true;
            good = bb[2] == 0 && bb[3] == 42;
        } else if (bb[0] == 73 && bb[1] == 73) {
            bigEndian = false;
            good = bb[2] == 42 && bb[3] == 0;
        } else {
            good = false;
        }
        if (!good) {
            throw new IOException("Bad TIFF magic number");
        }
        int width = -1;
        int height = -1;
        int ifd = 0;
        ifd = TiffUtils.readInt(dis, 4, bigEndian);
        dis.skip(ifd - 8);
        int entries = TiffUtils.readInt(dis, 2, bigEndian);
        for (int i = 1; i <= entries; ++i) {
            int valOffset;
            int tag = TiffUtils.readInt(dis, 2, bigEndian);
            int fieldType = TiffUtils.readInt(dis, 2, bigEndian);
            if (fieldType == 3 || fieldType == 8) {
                valOffset = TiffUtils.readInt(dis, 2, bigEndian);
                dis.skip(2L);
            } else {
                valOffset = TiffUtils.readInt(dis, 4, bigEndian);
            }
            if (tag == 256) {
                width = valOffset;
                continue;
            }
            if (tag != 257) continue;
            height = valOffset;
        }
        if (width > 0 && height > 0) {
            return new Dimension(width, height);
        }
        return null;
    }

    private static int readInt(InputStream is, int numBytes, boolean bigEndian) throws IOException {
        int ret = 0;
        int sv = bigEndian ? (numBytes - 1) * 8 : 0;
        int cnt = bigEndian ? -8 : 8;
        for (int i = 0; i < numBytes; ++i) {
            ret |= is.read() << sv;
            sv += cnt;
        }
        return ret;
    }

    private TiffUtils() {
    }
}

