/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.util.DescribedItem;

public enum PaperSize implements DescribedItem
{
    LETTER("US Letter", 215.9f, 279.4f),
    LEGAL("US Legal", 215.9f, 355.6f),
    LEDGER("US Ledger", 431.8f, 279.4f),
    A0("A0", 1189.0f, 841.0f),
    A1("A1", 841.0f, 594.0f),
    A2("A2", 594.0f, 420.0f),
    A3("A3", 420.0f, 297.0f),
    A4("A4", 297.0f, 210.0f),
    A5("A5", 210.0f, 148.0f),
    ANSI_A("ANSI A", 215.9f, 279.4f),
    ANSI_B("ANSI B", 279.4f, 431.8f),
    ANSI_C("ANSI C", 431.8f, 558.8f),
    ANSI_D("ANSI D", 558.8f, 863.6f),
    ANSI_E("ANSI E", 863.6f, 1117.6f),
    ARCH_A("Arch A", 228.6f, 304.8f),
    ARCH_B("Arch B", 304.8f, 457.2f),
    ARCH_C("Arch C", 457.2f, 609.6f),
    ARCH_D("Arch D", 609.6f, 914.4f),
    ARCH_E("Arch E", 914.4f, 1219.2f),
    ARCH_E1("Arch E1", 762.0f, 1066.8f),
    ARCH_E2("Arch E2", 660.4f, 965.2f),
    ARCH_E3("Arch E3", 685.8f, 990.6f);

    private final String description_;
    private final float widthMM_;
    private final float heightMM_;

    private PaperSize(String description, float widthMM, float heightMM) {
        this.description_ = description;
        this.widthMM_ = widthMM;
        this.heightMM_ = heightMM;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public float widthMM() {
        return this.widthMM_;
    }

    public float heightMM() {
        return this.heightMM_;
    }

    public int widthPts() {
        return (int)((double)(72.0f * this.widthMM_) / 25.4 + 0.5);
    }

    public int heightPts() {
        return (int)((double)(72.0f * this.heightMM_) / 25.4 + 0.5);
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PaperSize matching(String s) {
        for (PaperSize item : PaperSize.values()) {
            if (!item.matches(s)) continue;
            return item;
        }
        return null;
    }
}

