/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.ui;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDatasetList;
import gov.nasa.giss.data.nc.NcVarClass;
import gov.nasa.giss.ui.treetable.TreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcDataTreeTableModel
extends TreeTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Long Name", "Type"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{TreeTableModel.class, String.class, String.class};
    private static final int[] COLUMN_ALIGNMENTS = new int[]{2, 2, 0};
    protected NcVarClass visibleVarClass_ = NcVarClass.ALL;

    public NcDataTreeTableModel() {
        super(new NcDatasetList());
        this.setVisibleVarClass(NcVarClass.ALL);
    }

    @Override
    public int getColumnAlignment(int col) {
        return COLUMN_ALIGNMENTS[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return COLUMN_CLASSES[col];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public Object getValueAt(TreeTableNode node, int col) {
        NcDataNode ncn = (NcDataNode)node;
        try {
            switch (col) {
                case 0: {
                    return ncn.getName();
                }
                case 1: {
                    return ncn.getLongName();
                }
                case 2: {
                    LOGGER.trace("{}, {}", (Object)ncn.getName(), (Object)ncn.getNcType());
                    return ncn.getNcType();
                }
            }
            LOGGER.trace("Switch - How did we get here? {}", (Object)col);
            return null;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Override
    public void setValueAt(Object aValue, TreeTableNode node, int col) {
    }

    public NcDataset addDataset(NcDataset ncd) throws IOException {
        NcDataset already = this.datasetWithURL(ncd.getURL());
        if (already != null) {
            return already;
        }
        NcDatasetList ndl = (NcDatasetList)this.getRoot();
        ncd.setVisibleVarClass(null, this.visibleVarClass_);
        int index = ndl.addDataset(ncd, this.visibleVarClass_);
        this.nodeInserted(ndl, index, ncd);
        return ncd;
    }

    public void removeDataset(NcDataNode child) {
        block4: {
            if (!(child instanceof NcDataset)) {
                return;
            }
            NcDatasetList ndl = (NcDatasetList)this.getRoot();
            int index = ndl.getIndex(child);
            try {
                if (ndl.removeDataset((NcDataset)child)) {
                    this.nodeRemoved(ndl, index, child);
                }
            }
            catch (Exception exc) {
                LOGGER.error(exc.toString());
                if (!LOGGER.isTraceEnabled()) break block4;
                exc.printStackTrace();
            }
        }
    }

    public final void setVisibleVarClass(NcVarClass vclass) {
        this.visibleVarClass_ = vclass;
        NcDatasetList root = (NcDatasetList)this.getRoot();
        root.setVisibleVarClass(this, vclass);
    }

    public NcDataset datasetWithURL(URL url) {
        NcDatasetList root = (NcDatasetList)this.getRoot();
        String us = url.toString();
        for (TreeTableNode child : root.getChildren()) {
            NcDataset dataset = (NcDataset)child;
            String ds = dataset.getURL().toString();
            if (us.compareTo(ds) != 0) continue;
            return dataset;
        }
        return null;
    }
}

