/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.math.MathUtils;

public final class NcGridderUtils {
    private static final double TINY_VAL = 1.0E-10;

    public static double bilinearInterpolate(double xLeft, double yTop, double xRight, double yBottom, double valTL, double valTR, double valBL, double valBR, double x, double y) {
        double xPct = (x - xLeft) / (xRight - xLeft);
        double yPct = (y - yTop) / (yBottom - yTop);
        return NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
    }

    public static double bilinearInterpolate(double xPct, double yPct, double valTL, double valTR, double valBL, double valBR) {
        int badCorners = 0;
        if (Double.isNaN(valTL)) {
            ++badCorners;
        }
        if (Double.isNaN(valTR)) {
            ++badCorners;
        }
        if (Double.isNaN(valBL)) {
            ++badCorners;
        }
        if (Double.isNaN(valBR)) {
            ++badCorners;
        }
        if (badCorners == 0) {
            return NcGridderUtils.fourPoints(valTL, valTR, valBL, valBR, xPct, yPct);
        }
        if (badCorners == 4) {
            return Double.NaN;
        }
        if (badCorners == 3) {
            if (xPct < 0.5 && yPct < 0.5) {
                return valTL;
            }
            if (yPct < 0.5) {
                return valTR;
            }
            if (xPct < 0.5) {
                return valBL;
            }
            return valBR;
        }
        if (badCorners == 2) {
            if (Double.isNaN(valTL) && Double.isNaN(valTR)) {
                if (yPct < 0.5) {
                    return Double.NaN;
                }
                return NcGridderUtils.twoPoints(valBL, valBR, xPct);
            }
            if (Double.isNaN(valBL) && Double.isNaN(valBR)) {
                if (yPct < 0.5) {
                    return NcGridderUtils.twoPoints(valTL, valTR, xPct);
                }
                return Double.NaN;
            }
            if (Double.isNaN(valTL) && Double.isNaN(valBL)) {
                if (xPct < 0.5) {
                    return Double.NaN;
                }
                return NcGridderUtils.twoPoints(valTR, valBR, yPct);
            }
            if (Double.isNaN(valTR) && Double.isNaN(valBR)) {
                if (xPct < 0.5) {
                    return NcGridderUtils.twoPoints(valTL, valBL, yPct);
                }
                return Double.NaN;
            }
            if (xPct < 0.5 && yPct < 0.5) {
                return valTL;
            }
            if (yPct < 0.5) {
                return valTR;
            }
            if (xPct < 0.5) {
                return valBL;
            }
            return valBR;
        }
        if (Double.isNaN(valTL)) {
            if (xPct < 0.5 && yPct < 0.5) {
                return Double.NaN;
            }
            return NcGridderUtils.threePoints(valBR, valBL, valTR, 1.0 - xPct, 1.0 - yPct);
        }
        if (Double.isNaN(valTR)) {
            if (xPct >= 0.5 && yPct < 0.5) {
                return Double.NaN;
            }
            return NcGridderUtils.threePoints(valBL, valTL, valBR, 1.0 - yPct, xPct);
        }
        if (Double.isNaN(valBL)) {
            if (xPct < 0.5 && yPct >= 0.5) {
                return Double.NaN;
            }
            return NcGridderUtils.threePoints(valTR, valBR, valTL, yPct, 1.0 - xPct);
        }
        if (xPct < 0.5 || yPct < 0.5) {
            return NcGridderUtils.threePoints(valTL, valTR, valBL, xPct, yPct);
        }
        return Double.NaN;
    }

    public static double twoPoints(double value1, double value2, double percent) {
        if (value1 == value2) {
            return value1;
        }
        return value1 * (1.0 - percent) + value2 * percent;
    }

    private static double threePoints(double value1, double value2, double value3, double percentA, double percentB) {
        if (value1 == value2 && value2 == value3) {
            return value1;
        }
        double value4 = (value1 + value2 + value3) / 3.0;
        return value1 * (1.0 - percentB) * (1.0 - percentA) + value2 * (1.0 - percentB) * percentA + value3 * percentB * (1.0 - percentA) + value4 * percentB * percentA;
    }

    private static double fourPoints(double valueTL, double valueTR, double valueBL, double valueBR, double percentLR, double percentTB) {
        if (valueTL == valueTR && valueTR == valueBR && valueBR == valueBL) {
            return valueTL;
        }
        double dd = valueTL * (1.0 - percentTB) * (1.0 - percentLR) + valueTR * (1.0 - percentTB) * percentLR + valueBL * percentTB * (1.0 - percentLR) + valueBR * percentTB * percentLR;
        double minval = MathUtils.min(valueTL, valueTR, valueBL, valueBR);
        double maxval = MathUtils.max(valueTL, valueTR, valueBL, valueBR);
        if (dd < minval) {
            dd = minval;
        } else if (dd > maxval) {
            dd = maxval;
        }
        return dd;
    }

    public static void quadSolidFill(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double value, double[] target, int width, int height) {
        double xmin = MathUtils.min(x1, x2, x3, x4);
        double xmax = MathUtils.max(x1, x2, x3, x4);
        double ymin = MathUtils.min(y1, y2, y3, y4);
        double ymax = MathUtils.max(y1, y2, y3, y4);
        int ixmin = Math.max((int)xmin, 0);
        int ixmax = Math.min((int)xmax, width - 1);
        int iymin = Math.max((int)ymin, 0);
        int iymax = Math.min((int)ymax, height - 1);
        block0: for (int i = ixmin; i <= ixmax; ++i) {
            double x = 0.5 + (double)i;
            if (x < xmin) continue;
            if (x > xmax) break;
            for (int j = iymin; j <= iymax; ++j) {
                double y = 0.5 + (double)j;
                if (y < ymin) continue;
                if (y > ymax) continue block0;
                if (!NcGridderUtils.isPointInQuadrilateral(x, y, x1, y1, x2, y2, x3, y3, x4, y4)) continue;
                NcGridderUtils.setValue(target, i, j, value, width, height);
            }
        }
    }

    public static void triSolidFill(double x1, double y1, double x2, double y2, double x3, double y3, double val, double[] target, int width, int height) {
        double xmin = Math.min(x1, Math.min(x2, x3));
        double xmax = Math.max(x1, Math.max(x2, x3));
        double ymin = Math.min(y1, Math.min(y2, y3));
        double ymax = Math.max(y1, Math.max(y2, y3));
        int ixmin = Math.max((int)xmin, 0);
        int ixmax = Math.min((int)xmax, width - 1);
        int iymin = Math.max((int)ymin, 0);
        int iymax = Math.min((int)ymax, height - 1);
        block0: for (int i = ixmin; i <= ixmax; ++i) {
            double x = 0.5 + (double)i;
            if (x < xmin) continue;
            if (x > xmax) break;
            for (int j = iymin; j <= iymax; ++j) {
                double y = 0.5 + (double)j;
                if (y < ymin) continue;
                if (y > ymax) continue block0;
                if (!NcGridderUtils.isPointInTriangle(x, y, x1, y1, x2, y2, x3, y3)) continue;
                NcGridderUtils.setValue(target, i, j, val, width, height);
            }
        }
    }

    public static void quadInterpolateFill(double x1, double y1, double val1, double x2, double y2, double val2, double x3, double y3, double val3, double x4, double y4, double val4, double[] target, int width, int height) {
        NcGridderUtils.triInterpolateFill(x1, y1, val1, x2, y2, val2, x3, y3, val3, target, width, height);
        NcGridderUtils.triInterpolateFill(x1, y1, val1, x3, y3, val3, x4, y4, val4, target, width, height);
    }

    public static void triInterpolateFill(double x1, double y1, double val1, double x2, double y2, double val2, double x3, double y3, double val3, double[] target, int width, int height) {
        double c = x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2);
        if (c == 0.0) {
            return;
        }
        double a = y1 * (val2 - val3) + y2 * (val3 - val1) + y3 * (val1 - val2);
        double b = val1 * (x2 - x3) + val2 * (x3 - x1) + val3 * (x1 - x2);
        double d = -(x1 * (y2 * val3 - y3 * val2) + x2 * (y3 * val1 - y1 * val3) + x3 * (y1 * val2 - y2 * val1));
        double oneOverC = 1.0 / c;
        double xmin = MathUtils.min(x1, x2, x3);
        double xmax = MathUtils.max(x1, x2, x3);
        double ymin = MathUtils.min(y1, y2, y3);
        double ymax = MathUtils.max(y1, y2, y3);
        int ixmin = Math.max((int)xmin, 0);
        int ixmax = Math.min((int)xmax, width - 1);
        int iymin = Math.max((int)ymin, 0);
        int iymax = Math.min((int)ymax, height - 1);
        block0: for (int i = ixmin; i <= ixmax; ++i) {
            double x = 0.5 + (double)i;
            if (x < xmin) continue;
            if (x > xmax) break;
            for (int j = iymin; j <= iymax; ++j) {
                double y = 0.5 + (double)j;
                if (y < ymin) continue;
                if (y > ymax) continue block0;
                if (!NcGridderUtils.isPointInTriangle(x, y, x1, y1, x2, y2, x3, y3)) continue;
                double val = -(a * x + b * y + d) * oneOverC;
                NcGridderUtils.setValue(target, i, j, val, width, height);
            }
        }
    }

    public static void setValue(double[] array, int col, int row, double value, int width, int height) {
        if (col < 0 || col >= width) {
            return;
        }
        if (row < 0 || row >= height) {
            return;
        }
        int index = row * width + col;
        array[index] = value;
    }

    public static boolean isPointInQuadrilateral(double x, double y, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        if (NcGridderUtils.isPointInTriangle(x, y, x1, y1, x2, y2, x3, y3)) {
            return true;
        }
        return NcGridderUtils.isPointInTriangle(x, y, x1, y1, x3, y3, x4, y4);
    }

    public static boolean isPointInTriangle(double x, double y, double x1, double y1, double x2, double y2, double x3, double y3) {
        double b = (x2 - x1) * (y3 - y1) - (x3 - x1) * (y2 - y1);
        double b1 = ((x2 - x) * (y3 - y) - (x3 - x) * (y2 - y)) / b;
        double b2 = ((x3 - x) * (y1 - y) - (x1 - x) * (y3 - y)) / b;
        double b3 = ((x1 - x) * (y2 - y) - (x2 - x) * (y1 - y)) / b;
        if (b1 > 0.0 && b2 > 0.0 && b3 > 0.0) {
            return true;
        }
        return Math.abs(b1) < 1.0E-10 || Math.abs(b2) < 1.0E-10 || Math.abs(b3) < 1.0E-10;
    }

    public static boolean isPointInTriangle2(double x, double y, double x1, double y1, double x2, double y2, double x3, double y3) {
        boolean inside = false;
        if (y1 > y != y3 > y && x < (x3 - x1) * (y - y1) / (y3 - y1) + x1) {
            inside = !inside;
        }
        if (y2 > y != y1 > y && x < (x1 - x2) * (y - y2) / (y1 - y2) + x2) {
            inside = !inside;
        }
        if (y3 > y != y2 > y && x < (x2 - x3) * (y - y3) / (y2 - y3) + x3) {
            inside = !inside;
        }
        return inside;
    }

    private NcGridderUtils() {
    }
}

