/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLat;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import java.awt.Dimension;

public class NcGridderLonLatCartesian
extends NcGridderLonLat {
    public NcGridderLonLatCartesian() {
        this(100, 50);
    }

    public NcGridderLonLatCartesian(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderLonLatCartesian(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        int j;
        this.prepareGridAxes();
        NcArray2D nca = (NcArray2D)a;
        boolean hasBad = nca.hasBadValues();
        NcAxis xAxis = nca.getXAxis();
        NcAxis yAxis = nca.getYAxis();
        int numXs = xAxis.getLength();
        int numYs = yAxis.getLength();
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block0: for (j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < numYs; ++jj) {
                if (!(this.rowYY_[j] >= yBounds[jj][0] && this.rowYY_[j] < yBounds[jj][1]) && (!(this.rowYY_[j] < yBounds[jj][0]) || !(this.rowYY_[j] >= yBounds[jj][1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            double lon = this.colXX_[i];
            for (int ii = 0; ii < numXs; ++ii) {
                double leftII = xBounds[ii][0];
                double rightII = xBounds[ii][1];
                while (lon < leftII && lon < rightII) {
                    lon += 360.0;
                }
                while (lon > leftII && lon > rightII) {
                    lon -= 360.0;
                }
                if (!(lon >= leftII && lon < rightII) && (!(lon < leftII) || !(lon >= rightII))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (j = 0; j < this.gridHeight_; ++j) {
            if (srcRow[j] < 0) continue;
            for (int i = 0; i < this.gridWidth_; ++i) {
                if (srcCol[i] < 0) continue;
                double value = nca.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                NcGridderUtils.setValue(target, i, j, value, this.gridWidth_, this.gridHeight_);
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        double southEdge;
        this.prepareGridAxes();
        NcArray2D nca = (NcArray2D)a;
        boolean hasBad = nca.hasBadValues();
        NcAxis xAxis = nca.getXAxis();
        NcAxis yAxis = nca.getYAxis();
        double[] xVals = xAxis.getValues();
        double[] yVals = yAxis.getValues();
        double[][] yBounds = yAxis.getBounds();
        int numXs = xVals.length;
        int numYs = yVals.length;
        int lastX = xAxis.isWraparound() ? numXs : numXs - 1;
        int lastY = numYs - 1;
        boolean westToEast = xVals[1] > xVals[0];
        boolean northToSouth = yVals[0] > yVals[1];
        int northY = northToSouth ? 0 : lastY;
        int southY = northToSouth ? lastY : 0;
        double npValue = Double.NaN;
        double spValue = Double.NaN;
        boolean npAveraged = false;
        boolean spAveraged = false;
        double northYVal = yVals[northY];
        double southYVal = yVals[southY];
        double northEdge = northToSouth ? yBounds[0][0] : yBounds[lastY][1];
        double d = southEdge = northToSouth ? yBounds[lastY][1] : yBounds[0][0];
        if (90.0 - northYVal < (northEdge - northYVal) * 1.75) {
            try {
                npValue = nca.rowAverageOf(northY);
                npAveraged = true;
            }
            catch (Exception e) {
                npValue = Double.NaN;
            }
        }
        if (southYVal - -90.0 < (southYVal - southEdge) * 1.75) {
            try {
                spValue = nca.rowAverageOf(southY);
                spAveraged = true;
            }
            catch (Exception e) {
                spValue = Double.NaN;
            }
        }
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block4: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            if (npAveraged && this.rowYY_[j] > yVals[northY] && this.rowYY_[j] <= 90.0) {
                srcRow[j] = -9000;
                continue;
            }
            if (spAveraged && this.rowYY_[j] < yVals[southY] && this.rowYY_[j] >= -90.0) {
                srcRow[j] = -8000;
                continue;
            }
            for (int jj = 0; jj < lastY; ++jj) {
                if (!(this.rowYY_[j] >= yVals[jj] && this.rowYY_[j] < yVals[jj + 1]) && (!(this.rowYY_[j] <= yVals[jj]) || !(this.rowYY_[j] > yVals[jj + 1]))) continue;
                srcRow[j] = jj;
                continue block4;
            }
        }
        block6: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            double lon = this.colXX_[i];
            for (int ii = 0; ii < lastX; ++ii) {
                double rightII;
                double leftII = xVals[ii];
                double d2 = ii == numXs - 1 ? xVals[0] + (westToEast ? 360.0 : -360.0) : (rightII = xVals[ii + 1]);
                while (lon < leftII && lon < rightII) {
                    lon += 360.0;
                }
                while (lon > leftII && lon > rightII) {
                    lon -= 360.0;
                }
                if (!(lon >= leftII && lon < rightII) && (!(lon <= leftII) || !(lon > rightII))) continue;
                srcCol[i] = ii;
                continue block6;
            }
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            double yPct;
            if (srcRow[j] >= 0) {
                yPct = (this.rowYY_[j] - yVals[srcRow[j]]) / (yVals[srcRow[j] + 1] - yVals[srcRow[j]]);
            } else if (srcRow[j] == -9000) {
                if (!npAveraged) continue;
                yPct = (this.rowYY_[j] - 90.0) / (yVals[northY] - 90.0);
            } else {
                if (srcRow[j] != -8000 || !spAveraged) continue;
                yPct = (this.rowYY_[j] - yVals[southY]) / (-90.0 - yVals[southY]);
            }
            for (int i = 0; i < this.gridWidth_; ++i) {
                double valBR;
                double valBL;
                double valTR;
                double valTL;
                int colIP1;
                int colI = srcCol[i];
                int n = colIP1 = colI + 1 < numXs ? colI + 1 : 0;
                if (colI < 0) continue;
                double leftLon = xVals[colI];
                double rightLon = xVals[colIP1];
                if (westToEast) {
                    if (rightLon < leftLon) {
                        rightLon += 360.0;
                    }
                } else if (rightLon > leftLon) {
                    rightLon -= 360.0;
                }
                while (this.colXX_[i] < leftLon && this.colXX_[i] < rightLon) {
                    int n2 = i;
                    this.colXX_[n2] = this.colXX_[n2] + 360.0;
                }
                while (this.colXX_[i] > leftLon && this.colXX_[i] > rightLon) {
                    int n3 = i;
                    this.colXX_[n3] = this.colXX_[n3] - 360.0;
                }
                double xPct = (this.colXX_[i] - leftLon) / (rightLon - leftLon);
                if (srcRow[j] >= 0) {
                    valTL = nca.valueAt(colI, srcRow[j]);
                    valTR = nca.valueAt(colIP1, srcRow[j]);
                    valBL = nca.valueAt(colI, srcRow[j] + 1);
                    valBR = nca.valueAt(colIP1, srcRow[j] + 1);
                } else if (srcRow[j] == -9000) {
                    if (northToSouth) {
                        valTL = npValue;
                        valTR = npValue;
                        valBL = nca.valueAt(colI, northY);
                        valBR = nca.valueAt(colIP1, northY);
                    } else {
                        valTL = nca.valueAt(colI, northY);
                        valTR = nca.valueAt(colIP1, northY);
                        valBL = npValue;
                        valBR = npValue;
                    }
                } else {
                    if (srcRow[j] != -8000) continue;
                    if (northToSouth) {
                        valTL = nca.valueAt(colI, southY);
                        valTR = nca.valueAt(colIP1, southY);
                        valBL = spValue;
                        valBR = spValue;
                    } else {
                        valTL = spValue;
                        valTR = spValue;
                        valBL = nca.valueAt(colI, southY);
                        valBR = nca.valueAt(colIP1, southY);
                    }
                }
                if (hasBad) {
                    if (nca.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                NcGridderUtils.setValue(target, i, j, value, this.gridWidth_, this.gridHeight_);
            }
        }
    }
}

