/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAltGridding;
import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.util.List;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.proj4.EquidistantAzimuthalProjection;
import ucar.units.Converter;
import ucar.units.Unit;

public class NcArrayLonLatAzimuthalEquidistant
extends NcArrayLonLatProjected {
    private static final boolean USE_NJ_PROJ = false;
    private ProjectionImpl njProj_;
    private Converter toProjUnits_;
    private Converter fromProjUnits_;
    private double cosPhiC_;
    private double sinPhiC_;

    public NcArrayLonLatAzimuthalEquidistant(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.AZIM_EQUIDISTANT);
        this.initMe();
    }

    private final void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcAltGriddingVarType)vtype).isGrid(NcAltGridding.AZIM_EQUIDISTANT)) {
            throw new NcException("Variable is not projected type azimuthal equidistant.");
        }
        this.initGissProj();
    }

    private final void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = njvarDS.getCoordinateSystems();
        if (csList == null || csList.isEmpty()) {
            throw new NcException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (!(pj instanceof EquidistantAzimuthalProjection)) {
            throw new NcException("CoordinateSystem returned " + pj.getClass() + " instead of EquidistantAzimuthalProjection");
        }
        this.njProj_ = pj;
        String xUnits = this.getNjCoordinateAxis(NcAxisType.GEOX).getUnitsString();
        try {
            Unit projUnit = NcUnitUtils.parse("km");
            Unit eastUnit = NcUnitUtils.parse(xUnits);
            this.toProjUnits_ = eastUnit.getConverterTo(projUnit);
            this.fromProjUnits_ = projUnit.getConverterTo(eastUnit);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("azimuthal_equidistant")) {
            throw new NcException("Mapping name is not azimuthal_equidistant");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        this.cosPhiC_ = Math.cos(Math.toRadians(this.phiC_));
        this.sinPhiC_ = Math.sin(Math.toRadians(this.phiC_));
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        double lambdaRad = Math.toRadians(lon - this.lambdaC_);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ == -1.0) {
            return null;
        }
        double k = 1.0;
        if (cosZ < 1.0) {
            double z = Math.acos(cosZ);
            k = z / Math.sin(z);
        }
        double x = k * cosPhi * Math.sin(lambdaRad);
        double y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        return new Point2D.Double(x * this.radius_ + this.falseEasting_, y * this.radius_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        if (xx == 0.0 && yy == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double rho2 = xx * xx + yy * yy;
        double rho = Math.sqrt(rho2);
        double z = rho * this.oneOverR_;
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + yy * sinZ * this.cosPhiC_ / rho);
        double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - yy * this.sinPhiC_ * sinZ);
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

