/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayShort;
import ucar.ma2.Index;

public final class NcArrayUtils {
    public static double getDoubleFromSlice(Array slice, Index sliceIdx, boolean hasScaleOffset, boolean isUnsigned) {
        if (!hasScaleOffset) {
            if (slice instanceof ArrayByte) {
                long v = slice.getByte(sliceIdx);
                if (isUnsigned && v < 0L) {
                    v += 256L;
                }
                return v;
            }
            if (slice instanceof ArrayShort) {
                long v = slice.getShort(sliceIdx);
                if (isUnsigned && v < 0L) {
                    v += 65536L;
                }
                return v;
            }
            if (slice instanceof ArrayInt) {
                long v = slice.getInt(sliceIdx);
                if (isUnsigned && v < 0L) {
                    v += 0x100000000L;
                }
                return v;
            }
        }
        return slice.getDouble(sliceIdx);
    }

    private NcArrayUtils() {
    }
}

