/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcStringUtils;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonTime;
import gov.nasa.giss.text.PrintfFormat;
import java.util.Objects;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonTime
extends NcArray2D {
    public NcArrayLonTime(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.setAxes();
        this.measureAxes();
    }

    private final void setAxes() {
        VariableDS cv;
        NcDataset ncd = this.getDataset();
        CoordinateAxis x = this.getNjCoordinateAxis(NcAxisType.LON);
        CoordinateAxis y = this.getNjCoordinateAxis(NcAxisType.TIME);
        if (x == null) {
            cv = this.getCoordinateVar(NcAxisType.LON);
            if (cv != null) {
                this.xAxis_ = new NcAxis(NcAxisType.LON, ncd, cv);
                this.xDimNum_ = this.findDimensionIndex(cv);
            }
        } else {
            this.xAxis_ = new NcAxis(ncd, x);
            this.xDimNum_ = this.findDimensionIndex(x);
        }
        if (y == null) {
            cv = this.getCoordinateVar(NcAxisType.TIME);
            if (cv != null) {
                this.yAxis_ = new NcTimeAxis(ncd, cv);
                this.yDimNum_ = this.findDimensionIndex(cv);
            }
        } else {
            this.yAxis_ = new NcTimeAxis(ncd, (Variable)y);
            this.yDimNum_ = this.findDimensionIndex(y);
        }
        if (this.xAxis_ == null) {
            throw new NcException("Got null retrieving LON axis coordinate variable");
        }
        if (this.yAxis_ == null) {
            throw new NcException("Got null retrieving TIME axis coordinate variable");
        }
        if (this.xDimNum_ == -1) {
            throw new NcException("Unable to determine din num for LON axis");
        }
        if (this.yDimNum_ == -1) {
            throw new NcException("Unable to determine din num for TIME axis");
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonTime();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (col < 0 || row < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        int colDisplay = col + 1;
        int rowDisplay = row + 1;
        double lon = this.xAxis_.valueAt(col);
        double time = this.yAxis_.valueAt(row);
        double value = this.valueAt(col, row);
        sb.append("Cell [").append(colDisplay).append(", ").append(rowDisplay).append("] at [").append(NcStringUtils.formatLongitude(lon)).append(", ").append(PrintfFormat.PFORMAT_7G.sprintg(time)).append("], value = ").append(valFormat.sprintf((Object)value));
        if (Double.isNaN(value)) {
            return;
        }
        String unitsStr = this.getUnitsString();
        if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
            sb.append(' ').append(unitsStr);
        }
    }
}

