/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.map.LonLatBounds;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NcArrayLonLat {
    public static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public int[] getEnclosingCell(double var1, double var3);

    default public LonLatBounds getLonLatBounds() {
        LOGGER.warn("Not yet implemented.");
        return null;
    }

    public static boolean isBadLongitude(double lon) {
        return lon > 720.0 || lon < -720.0 || Double.isNaN(lon);
    }

    public static boolean isBadLatitude(double lat) {
        return lat > 90.0 || lat < -90.0 || Double.isNaN(lat);
    }

    public static boolean isBadLonLat(double lon, double lat) {
        return NcArrayLonLat.isBadLongitude(lon) || NcArrayLonLat.isBadLatitude(lat);
    }
}

