@echo off
echo Extract MSG-based fire product (FIRC), CAP format (Common Alert Protocol)
echo Filename convention: L-000-MSG1__-MPEF_RSS____-FIRC_____-000001___-200905081050-__
echo Pixels with value 1 are classified as "Possible", fire probability is less or equal 50 percent
echo Pixels with value 2 are classified as "Likely", fire probability is greater than 50 percent
echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
cd\
%OutputDrive%
cd %OutputDir%

set MSG_number=1

copy "%InputDrive%\%InputDir%\L-000-MSG?__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__" 

if exist "%OutputDrive%\%OutputDir%\L-000-MSG1__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__" GOTO START

set MSG_number=2

if exist "%OutputDrive%\%OutputDir%\L-000-MSG2__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__" GOTO START

set MSG_number=3


:START1
if not exist "%InputDrive%\%InputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-FIRC_____-00000?___-%shortfilename1%-__" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START


"%UtilDir%\joinmdd3.exe" "%OutputDrive%\%OutputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__" %OutputDrive%\%OutputDir%\

"%UtilDir%\ConvertFIRC.jar" "%OutputDrive%\%OutputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__.xyz"


if not exist "%OutputDrive%\%OutputDir%\l-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__Likely.csv" GOTO POSSIBLE



"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FIRC_likelyRSS%shortfilename1%.tbt=table('%OutputDrive%\%OutputDir%\l-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__Likely'.csv,Comma,Convert,none,Y(value.dom{-90.0000:90.0000:0.0001}),X(value.dom{-180.0000:180.0000:0.0001}),Radius(value.dom{0.0000:500.0000:0.0001}))
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FIRC_likelyRSS%shortfilename1%.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\FIRC_likelyRSS%shortfilename1%,LatlonWGS84,Radius)

:POSSIBLE

if not exist "%OutputDrive%\%OutputDir%\l-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__possible.csv" GOTO END


"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FIRC_possibleRSS%shortfilename1%.tbt=table('%OutputDrive%\%OutputDir%\l-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__possible'.csv,Comma,Convert,none,Y(value.dom{-90.0000:90.0000:0.0001}),X(value.dom{-180.0000:180.0000:0.0001}),Radius(value.dom{0.0000:500.0000:0.0001}))
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FIRC_possibleRSS%shortfilename1%.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\FIRC_possibleRSS%shortfilename1%,LatlonWGS84,Radius)



del L-000-MSG?__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__.xyz
del L-000-MSG?__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__ 
del L-000-MSG?__-MPEF_RSS____-FIRC_____-000001___-%shortfilename1%-__*.csv 



:END
"%IlwDir%\ilwis.exe" -C closeall
