@Echo off
echo CSR-import of RSS
echo  merging of files (type BUFR)
echo only percentage cloud cover is transformed into a grid map
rem for the undefined grid no information is avaialble from the source bufr data file
rem use is made of the MSG projection 
rem data is resampled from point to grid using a grid resolution of 48 km


echo Note that import can take some time as large number of record need to be processed
echo Be patient as various columns in a table are being calculated

echo For quick visualization of the CSR file use BUFRDisplay
echo Relevant coordinate variables are: 12-latitude (code 5001), 13-longitude (code 6001)
echo Relevant parameters are: 42-Cloud_Amount_in_Segment (code 20081), 43-Amount_Segment_Cloud_Free (code 20082)
echo.
echo.

rem file name convention L-000-MSG1__-MPEF_RSS____-CSR______-000001___-201303050900-__

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

set MSG_number=1


copy "%InputDrive%\%InputDir%\L-000-MSG?__-MPEF_RSS____-CSR______-00000?___-%shortfilename1%-__" 


if exist "%OutputDrive%\%OutputDir%\L-000-MSG1__-MPEF_RSS____-CSR______-000001___-%shortfilename1%-__*.*" GOTO START1

set MSG_number=2

if exist "%OutputDrive%\%OutputDir%\L-000-MSG2__-MPEF_RSS____-CSR______-000001___-%shortfilename1%-__*.*" GOTO START1

set MSG_number=3

:START1
if not exist "%InputDrive%\%InputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-CSR______-000001___-%shortfilename1%-__"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-CSR______-000001___-%shortfilename1%-__" will be copied to your current working directory
echo.
echo.

GOTO START


:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\joinmsg.exe" "L-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-CSR______-000001___-%shortfilename1%-__" %OutputDrive%\%OutputDir%\

ren L-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-CSR______-000001___-%shortfilename1%-__.xyz rss_csr%shortfilename1%.bufr



echo.
echo.
echo Renamed input file = rss_csr%shortfilename1%.bufr
echo.
echo.




copy rss_csr%shortfilename1%.bufr "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract" > NUL

cd /d "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract"

bufrextract.exe rss_csr%shortfilename1%.bufr -oddump.csv > mess.txt 2>&1

cd /d "%OutputDrive%\%OutputDir%"

copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv" > NUL

del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\rss_csr%shortfilename1%.bufr"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\mess.txt"

findstr /b /v "0" dump.csv > dump1.csv
findstr /b /v "#" dump1.csv > dump2.csv 


copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\ConvertCSV.class 

java ConvertCSV 14 13 43 44 < dump2.csv > dump3.csv 


echo off
echo.
echo.
echo Importing data from BUFR file into ILWIS and create output maps
echo Wait until routine is completed
echo.


"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\rss_csr%shortfilename1%.tbt:=table(%OutputDrive%\%OutputDir%\dump3.csv,Comma,Convert,none,X(value.dom{-90:90:0.00001}),Y(value.dom{-90:90:0.00001}),Perc_cloud(value.dom{0:100:1}),Perc_cloudfree(value.dom{0:100:1}))

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\rss_csr_points%shortfilename1%.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\rss_csr%shortfilename1%,X,Y,LatlonWGS84,Perc_cloud)

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\rss_csr_grid%shortfilename1%.mpr{dom=value;vr=0:100}:=MapRasterizePoint(%OutputDrive%\%OutputDir%\rss_csr_points%shortfilename1%,'%UtilDir%\fcc0000'.grf,16)


del L-000-MSG%MSG_number:~0,1%__-MPEF_RSS____-CSR______-00000?___-%shortfilename1%-__*.*
del rss_csr%shortfilename1%.bufr
del dump*.csv
del ConvertCSV.class

:END
"%IlwDir%\ilwis.exe" -C closeall




