@echo off

echo MODIS Diffuse attenuation coefficient at 490 nm KD490 (Modis, Mapped 4 KM) - Aqua
echo Input filename format expected is A2020034.L3m_DAY_KD490_Kd_490_4km.nc


set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~0,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
set MODIS_DAY=%9

cd\
%OutputDrive%
cd %OutputDir%


:manualDATE
rem get date from interface - user as longfilename
set ldt=%longfilename:~0,8%


SETLOCAL

set yy=%ldt:~0,4%
set mm=%ldt:~4,2%
set dd=%ldt:~6,2%

set /a "yy=10000%yy% %%10000,mm=100%mm% %% 100,dd=100%dd% %% 100"
set /a JD=dd-32075+1461*(yy+4800+(mm-14)/12)/4+367*(mm-2-(mm-14)/12*12)/12-3*((yy+4900+(mm-14)/12)/100)/4
set /a "yy=10000%yy% %%10000,mm=1,dd=1"
set /a JD-=-1+dd-32075+1461*(yy+4800+(mm-14)/12)/4+367*(mm-2-(mm-14)/12*12)/12-3*((yy+4900+(mm-14)/12)/100)/4




if %JD% LEQ 9 (
set JD=00%JD%
)

rem echo %JD%

IF %JD% GEQ 10 (
	IF %JD% LSS 100 (
	set JD=0%JD%)
)

rem echo %JD%

if %JD% GEQ 100 (
set JD=%JD%
)

set full_doy=%ldt:~0,4%%JD%
echo calculated DoY: %JD%
echo timestamp used %full_doy%
echo Current entered date [yyyymmdd]: %ldt%

echo.

echo.


echo %OutputDrive%\%OutputDir%




copy "%InputDrive%\%InputDir%\A%full_doy%.L3m_DAY_KD490_Kd_490_4km.nc" %OutputDrive%\%OutputDir%\*.*

if not exist "%OutputDrive%\%OutputDir%\A%full_doy%.L3m_DAY_KD490_Kd_490_4km.nc" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\A%full_doy%.L3m_DAY_KD490_Kd_490_4km.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Your current Julian date stamp used is %modis_day%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START




"%gdalDir%\gdal_translate" -of ilwis HDF5:"A%full_doy%.L3m_DAY_KD490_Kd_490_4km.nc"://kd_490 %OutputDrive%\%OutputDir%\tkd490%shortfilename1%

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\Modis_kd490%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tkd490%shortfilename1% ge 0,%OutputDrive%\%OutputDir%\tkd490%shortfilename1%*0.00019999999,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\Modis_kd490%shortfilename1%.mpr %UtilDir%\chloro;

del A%full_doy%.L3m_DAY_KD490_Kd_490_4km.*
del tkd490%shortfilename1%.mp*
del tkd490%shortfilename1%.aux.xml



:END
"%IlwDir%\ilwis.exe" -C closeall