@echo off
echo Data retrieved from https://hydro1.gesdisc.eosdis.nasa.gov/data/GLDAS/GLDAS_NOAH025_3H.2.1/
echo Data resides under year and julian day dated sub-directories
echo 8 files per day are downloaded and each file contains a 3 hr time step
echo.
echo.
 
set longfilename=%1
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.

Rem clean output folder
if exist .urs_cookies del .urs_cookies
rem NUL > .urs_cookies 
echo.>.urs_cookies 
if exist .wget-hsts del .wget-hsts
if exist downloadlist.dat del downloadlist.dat
if exist inputparam.bat del inputparam.bat


Rem retrieve day of your for input folder directory structure
set ldt=%longfilename%

SETLOCAL

set yy=%ldt:~0,4%
set mm=%ldt:~4,2%
set dd=%ldt:~6,2%

set /a "yy=10000%yy% %%10000,mm=100%mm% %% 100,dd=100%dd% %% 100"
set /a JD=dd-32075+1461*(yy+4800+(mm-14)/12)/4+367*(mm-2-(mm-14)/12*12)/12-3*((yy+4900+(mm-14)/12)/100)/4
set /a "yy=10000%yy% %%10000,mm=1,dd=1"
set /a JD-=-1+dd-32075+1461*(yy+4800+(mm-14)/12)/4+367*(mm-2-(mm-14)/12*12)/12-3*((yy+4900+(mm-14)/12)/100)/4

if %JD% LEQ 9 (
set JD=00%JD%
)

rem echo %JD%

IF %JD% GEQ 10 (
	IF %JD% LSS 100 (
	set JD=0%JD%)
)

rem echo %JD%

if %JD% GEQ 100 (
set JD=%JD%
)

set full_doy=%ldt:~0,4%%JD%
echo calculated DoY: %JD%
echo timestamp used %full_doy%
echo Current entered date [yyyymmdd]: %ldt%

echo.
echo.

rem prepare file list for wget
rem create txt file to import 8 files - downloadlist.dat

echo https://hydro1.gesdisc.eosdis.nasa.gov/data/GLDAS/GLDAS_NOAH025_3H.2.1/%yy%/%JD%/GLDAS_NOAH025_3H.A%ldt%.0000.021.nc4>downloadlist.dat
echo https://hydro1.gesdisc.eosdis.nasa.gov/data/GLDAS/GLDAS_NOAH025_3H.2.1/%yy%/%JD%/GLDAS_NOAH025_3H.A%ldt%.0300.021.nc4>>downloadlist.dat
echo https://hydro1.gesdisc.eosdis.nasa.gov/data/GLDAS/GLDAS_NOAH025_3H.2.1/%yy%/%JD%/GLDAS_NOAH025_3H.A%ldt%.0600.021.nc4>>downloadlist.dat
echo https://hydro1.gesdisc.eosdis.nasa.gov/data/GLDAS/GLDAS_NOAH025_3H.2.1/%yy%/%JD%/GLDAS_NOAH025_3H.A%ldt%.0900.021.nc4>>downloadlist.dat
echo https://hydro1.gesdisc.eosdis.nasa.gov/data/GLDAS/GLDAS_NOAH025_3H.2.1/%yy%/%JD%/GLDAS_NOAH025_3H.A%ldt%.1200.021.nc4>>downloadlist.dat
echo https://hydro1.gesdisc.eosdis.nasa.gov/data/GLDAS/GLDAS_NOAH025_3H.2.1/%yy%/%JD%/GLDAS_NOAH025_3H.A%ldt%.1500.021.nc4>>downloadlist.dat
echo https://hydro1.gesdisc.eosdis.nasa.gov/data/GLDAS/GLDAS_NOAH025_3H.2.1/%yy%/%JD%/GLDAS_NOAH025_3H.A%ldt%.1800.021.nc4>>downloadlist.dat
echo https://hydro1.gesdisc.eosdis.nasa.gov/data/GLDAS/GLDAS_NOAH025_3H.2.1/%yy%/%JD%/GLDAS_NOAH025_3H.A%ldt%.2100.021.nc4>>downloadlist.dat

set /p user=Enter your User Name:

"%UtilDir%\wget\wget.exe" --load-cookies .urs_cookies --save-cookies .urs_cookies --auth-no-challenge=on --keep-session-cookies --user=%user% --ask-password -c -N --content-disposition -i downloadlist.dat


echo off
if not exist "%OutputDrive%\%OutputDir%\GLDAS_NOAH025_3H.A%ldt%.0000.021.nc4"  goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\GLDAS_NOAH025_3H.A%ldt%.0300.021.nc4"  goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\GLDAS_NOAH025_3H.A%ldt%.0600.021.nc4"  goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\GLDAS_NOAH025_3H.A%ldt%.0900.021.nc4"  goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\GLDAS_NOAH025_3H.A%ldt%.1200.021.nc4"  goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\GLDAS_NOAH025_3H.A%ldt%.1500.021.nc4"  goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\GLDAS_NOAH025_3H.A%ldt%.1800.021.nc4"  goto MESSAGE
if not exist "%OutputDrive%\%OutputDir%\GLDAS_NOAH025_3H.A%ldt%.2100.021.nc4"  goto MESSAGE

echo.
echo All the 8 "GLDAS_NOAH025_3H.2.1.nc4" files have been successfully retrieved to your current working directory
echo.
echo.


GOTO START

:MESSAGE
echo The input files are not found.
echo Check your directory and date stamp settings, note the day of the year stamp
echo Your current date stamp used is %ldt%
echo Check also if the data exists on your input directory - archive 


pause

GOTO END

:START

echo set OutputDrive=%4>inputparam.bat
echo set OutputDir=%5>>inputparam.bat
echo set GdalDir=%6>>inputparam.bat
echo set IlwDir=%7>>inputparam.bat
echo set UtilDir=%8>>inputparam.bat


echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.

echo GLDAS-NOAH layers processed for 3 hourly time step are: 
echo.
echo Average Surface temperature - unit in Kelvin - average, minimum and maximum / day
echo Average Evaporation - unit im mm/timestep - sum map in mm/day
echo Average Potential Evaporation - unit im mm/timestep - sum map in mm/day
echo Average Rainfall - unit im mm/timestep - sum map in mm/day
echo Soil Moisture at 0-10 cm - unit m3/m3 - average per layer/day im m3/m3
echo Soil Moisture at 10-40 cm - unit m3/m3 - average per layer/day im m3/m3
echo Soil Moisture at 40-100 cm - unit m3/m3 - average per layer/day im m3/m3
echo Soil Moisture at 100-200 cm - unit m3/m3 - average per layer/day im m3/m3

echo.
echo Wait until processing is completed

copy "%IlwDir%\Extensions\geonetcast-Toolbox\toolbox_batchroutines\gldas_noah_loop.bat" >nul

for %%j in (GLDAS_NOAH025_3H.A%ldt%*) do cmd /c gldas_noah_loop.bat %%j

echo.
echo Creating aggregated daily maps

copy "%UtilDir%\mpl_substitutename.bat" >nul
copy "%UtilDir%\gldas_AvgSurfT_master.mpl" >nul

rem ====== process AvgSurfT========
rem create maplist AvgSurfT
cmd /c mpl_substitutename.bat ______ _%ldt%_ gldas_AvgSurfT_master.mpl > gldas_AvgSurfT_%ldt%.mpl
rem calculate Agv AvgSurfT
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_SurfTAVG_%ldt%.mpr:=MapMaplistStatistics(gldas_AvgSurfT_%ldt%.mpl,Avg)
rem calculate Max AvgSurfT
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_SurfTMax_%ldt%.mpr:=MapMaplistStatistics(gldas_AvgSurfT_%ldt%.mpl,Max)
rem calculate Min AvgSurfT
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_SurfTMin_%ldt%.mpr:=MapMaplistStatistics(gldas_AvgSurfT_%ldt%.mpl,Min)

rem ====== process AvgEvap========
copy "%UtilDir%\gldas_AvgEvap_master.mpl" >nul
cmd /c mpl_substitutename.bat ______ _%ldt%_ gldas_AvgEvap_master.mpl > gldas_AvgEvap_%ldt%.mpl
rem calculate sum AvgEvap
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_EvapSum_%ldt%.mpr:=MapMaplistStatistics(gldas_AvgEvap_%ldt%.mpl,Sum)

rem ====== process PotEvap_tavg========
copy "%UtilDir%\gldas_PotEvap_master.mpl" >nul
cmd /c mpl_substitutename.bat ______ _%ldt%_ gldas_PotEvap_master.mpl > gldas_AvgPotEvap_%ldt%.mpl
rem calculate sum AvgPotEvap
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_PotEvapSum_%ldt%.mpr:=MapMaplistStatistics(gldas_AvgPotEvap_%ldt%.mpl,Sum)

rem ====== process Rainf_f_tavg========
copy "%UtilDir%\gldas_Rainf_master.mpl" >nul
cmd /c mpl_substitutename.bat ______ _%ldt%_ gldas_Rainf_master.mpl > gldas_AvgRainf_%ldt%.mpl
rem calculate sum AvgRainf
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_RainfSum_%ldt%.mpr:=MapMaplistStatistics(gldas_AvgRainf_%ldt%.mpl,Sum)

rem ====== process gldas_SoilMoi0_10cm_inst========
copy "%UtilDir%\gldas_soilmoi0_10cm_master.mpl" >nul
cmd /c mpl_substitutename.bat ______ _%ldt%_ gldas_soilmoi0_10cm_master.mpl > gldas_soilmoi0_10cm_%ldt%.mpl
rem calculate Avg soilmoi0_10cm
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_Soilmoi0_10cmAvg_%ldt%.mpr:=MapMaplistStatistics(gldas_soilmoi0_10cm_%ldt%.mpl,Avg)

rem ====== process gldas_SoilMoi10_40cm_inst========
copy "%UtilDir%\gldas_soilmoi10_40cm_master.mpl" >nul
cmd /c mpl_substitutename.bat ______ _%ldt%_ gldas_soilmoi10_40cm_master.mpl > gldas_soilmoi10_40cm_%ldt%.mpl
rem calculate Avg soilmoi10_40cm
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_Soilmoi10_40cmAvg_%ldt%.mpr:=MapMaplistStatistics(gldas_soilmoi10_40cm_%ldt%.mpl,Avg)

rem ====== process gldas_SoilMoi40_100cm_inst========
copy "%UtilDir%\gldas_soilmoi40_100cm_master.mpl" >nul
cmd /c mpl_substitutename.bat ______ _%ldt%_ gldas_soilmoi40_100cm_master.mpl > gldas_soilmoi40_100cm_%ldt%.mpl
rem calculate Avg soilmoi40_100cm
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_Soilmoi40_100cmAvg_%ldt%.mpr:=MapMaplistStatistics(gldas_soilmoi40_100cm_%ldt%.mpl,Avg)

rem ====== process gldas_SoilMoi100_200cm_inst========
copy "%UtilDir%\gldas_soilmoi100_200cm_master.mpl" >nul
cmd /c mpl_substitutename.bat ______ _%ldt%_ gldas_soilmoi100_200cm_master.mpl > gldas_soilmoi100_200cm_%ldt%.mpl
rem calculate Avg soilmoi100_200cm
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\gldas_Soilmoi100_200cmAvg_%ldt%.mpr:=MapMaplistStatistics(gldas_soilmoi100_200cm_%ldt%.mpl,Avg)

rem ====== create gldas_SoilMoisture AVG maplist========
copy "%UtilDir%\gldas_soilmoiAvg0_200_master.mpl" >nul
cmd /c mpl_substitutename.bat _____ _%ldt% gldas_soilmoiAvg0_200_master.mpl > gldas_soilmoi0_200cmAVG_%ldt%.mpl

del %OutputDrive%\%OutputDir%\inputparam.bat
del %OutputDrive%\%OutputDir%\gldas_noah_loop.bat
del %OutputDrive%\%OutputDir%\GLDAS_NOAH025_3H.A%ldt%.??00.021.nc4
del %OutputDrive%\%OutputDir%\downloadlist.dat
del %OutputDrive%\%OutputDir%\mpl_substitutename.bat
del %OutputDrive%\%OutputDir%\gldas_AvgSurfT_master.mpl
del %OutputDrive%\%OutputDir%\.urs_cookies
del %OutputDrive%\%OutputDir%\gldas_AvgEvap_master.mpl
del %OutputDrive%\%OutputDir%\gldas_PotEvap_master.mpl
del %OutputDrive%\%OutputDir%\gldas_Rainf_master.mpl
del %OutputDrive%\%OutputDir%\gldas_soilmoi0_10cm_master.mpl
del %OutputDrive%\%OutputDir%\gldas_soilmoi10_40cm_master.mpl
del %OutputDrive%\%OutputDir%\gldas_soilmoi40_100cm_master.mpl
del %OutputDrive%\%OutputDir%\gldas_soilmoi100_200cm_master.mpl
del %OutputDrive%\%OutputDir%\gldas_soilmoiAvg0_200_master.mpl

:END
"%IlwDir%\ilwis.exe" -C closeall