@echo off 
echo Normalised water leaving radiance measured at a given wavelength (in nm) by the MODIS sensor
echo Output maps of surface upwelling spectral radiance in air emerging from sea water
echo units: mW cm^-2 um^-1 sr^-1
echo filename convention PML_Tanzania_MODIS_oc_refined_20110330125000.nc.bz2


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\PML_Tanzania_MODIS_oc_refined_%shortfilename1%00.nc.bz2" "%OutputDrive%\%OutputDir%\*.*"

if not exist "%OutputDrive%\%OutputDir%\PML_Tanzania_MODIS_oc_refined_%shortfilename1%00.nc.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\PML_Tanzania_MODIS_oc_refined_%shortfilename1%00.nc.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the timestamp of your data file

pause

GOTO END

:START

"%UtilDir%\7z" e PML_Tanzania_MODIS_oc_refined_%shortfilename1%00.nc.bz2

"%GdalDir%\gdal_translate.exe" -of ilwis NETCDF:"PML_Tanzania_MODIS_oc_refined_%shortfilename1%00.nc":nLw_443 %OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_443.mpr
"%GdalDir%\gdal_translate.exe" -of ilwis NETCDF:"PML_Tanzania_MODIS_oc_refined_%shortfilename1%00.nc":nLw_488 %OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_488.mpr
"%GdalDir%\gdal_translate.exe" -of ilwis NETCDF:"PML_Tanzania_MODIS_oc_refined_%shortfilename1%00.nc":nLw_547 %OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_547.mpr
"%GdalDir%\gdal_translate.exe" -of ilwis NETCDF:"PML_Tanzania_MODIS_oc_refined_%shortfilename1%00.nc":nLw_667 %OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_667.mpr

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_443.mpr %UtilDir%\pml_modis_Tanzania.grf;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_488.mpr %UtilDir%\pml_modis_Tanzania.grf;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_547.mpr %UtilDir%\pml_modis_Tanzania.grf;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_667.mpr %UtilDir%\pml_modis_Tanzania.grf;

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\PML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_443.mpr{dom=value;vr=0.000:250.000:0.00001}:=iff(%OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_443 ge 0,tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_443,?);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\PML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_488.mpr{dom=value;vr=0.000:250.000:0.00001}:=iff(%OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_488 ge 0,tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_488,?);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\PML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_547.mpr{dom=value;vr=0.000:250.000:0.00001}:=iff(%OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_547 ge 0,tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_547,?);
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\PML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_667.mpr{dom=value;vr=0.000:250.000:0.00001}:=iff(%OutputDrive%\%OutputDir%\tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_667 ge 0,tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_667,?);


del tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_443.mp*
del tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_488.mp*
del tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_443.grf
del tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_488.grf
del tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_547.mp*
del tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_667.mp*
del tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_547.grf
del tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_667.grf
del tPML_Tanzania_MODIS_oc_refined_%shortfilename1%_nLw_???.csy
del PML_Tanzania_MODIS_oc_refined_%shortfilename1%00.nc.bz2
del PML_Tanzania_MODIS_oc_refined_%shortfilename1%00.nc


:END
"%IlwDir%\ilwis.exe" -C closeall