@echo off 
echo Cloud Temperature /height Import
echo From Nowcasting SAF
echo For full MSG disk
echo Parameters retrieved are: Cloudiness(Percentage) - Temperature(K)  - Pressure(hPa) - Height(m)
rem Filename convention SAFNWC_MSG3_CTTH__201404170930_FES_________.h5
echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,12%

set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

set MSG_number=2


echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\SAFNWC_MSG?_CTTH_%shortfilename1%_FES_________.h5" "%OutputDrive%\%OutputDir%\*.*"


if exist "%InputDrive%\%InputDir%\SAFNWC_MSG2_CTTH_%shortfilename1%_FES_________.h5" GOTO START

set MSG_number=3
if exist "%InputDrive%\%InputDir%\SAFNWC_MSG3_CTTH_%shortfilename1%_FES_________.h5" GOTO START
set MSG_number=4

:START1
if not exist "%OutputDrive%\%OutputDir%\SAFNWC_MSG%MSG_number:~0,1%_CTTH_%shortfilename1%_FES_________.h5" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\SAFNWC_MSG%MSG_number:~0,1%_CTTH_%shortfilename1%_FES_________.h5" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 


pause

GOTO END

:START

echo.
rem Cloudiness
echo Retrieve Cloudiness
echo.
"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"SAFNWC_MSG%MSG_number:~0,1%_CTTH_%shortfilename1%_FES_________.h5"://CTTH_EFFECT %OutputDrive%\%OutputDir%\CTTH_teffect_%shortfilename1%.mpr

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\CTTH_teffect_%shortfilename1%'.mpr '%UtilDir%\fcc0000'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CTTH_effect_%shortfilename1%'{dom=value;vr=0:100:1}:=iff('%OutputDrive%\%OutputDir%\CTTH_teffect_%shortfilename1%' gt 9,5*'%OutputDrive%\%OutputDir%\CTTH_teffect_%shortfilename1%'-50,?)


del "%OutputDrive%\%OutputDir%\CTTH_teffect_%shortfilename1%.mpr.aux.xml"
del "%OutputDrive%\%OutputDir%\CTTH_teffect_%shortfilename1%.mp*"


echo.
rem Temperature
echo Retrieve Temperature
echo.
"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"SAFNWC_MSG%MSG_number:~0,1%_CTTH_%shortfilename1%_FES_________.h5"://CTTH_TEMPER %OutputDrive%\%OutputDir%\CTTH_ttemper_%shortfilename1%.mpr

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\CTTH_ttemper_%shortfilename1%'.mpr '%UtilDir%\fcc0000'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CTTH_temperature_%shortfilename1%'{dom=value;vr=0:500:1}:=iff('%OutputDrive%\%OutputDir%\CTTH_ttemper_%shortfilename1%' gt 0,1*'%OutputDrive%\%OutputDir%\CTTH_ttemper_%shortfilename1%'+150,?)


del "%OutputDrive%\%OutputDir%\CTTH_ttemper_%shortfilename1%.mpr.aux.xml"
del "%OutputDrive%\%OutputDir%\CTTH_ttemper_%shortfilename1%.mp*"


echo.
rem Pressure
echo Retrieve Pressure
echo.
"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"SAFNWC_MSG%MSG_number:~0,1%_CTTH_%shortfilename1%_FES_________.h5"://CTTH_PRESS %OutputDrive%\%OutputDir%\CTTH_tpress_%shortfilename1%.mpr

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\CTTH_tpress_%shortfilename1%'.mpr '%UtilDir%\fcc0000'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CTTH_pressure_%shortfilename1%'{dom=value;vr=0:1500:1}:=iff('%OutputDrive%\%OutputDir%\CTTH_tpress_%shortfilename1%' gt 0,25*'%OutputDrive%\%OutputDir%\CTTH_tpress_%shortfilename1%'-250,?)


del "%OutputDrive%\%OutputDir%\CTTH_tpress_%shortfilename1%.mpr.aux.xml"
del "%OutputDrive%\%OutputDir%\CTTH_tpress_%shortfilename1%.mp*"


echo.
rem Height 
echo Retrieve Height
echo.
"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"SAFNWC_MSG%MSG_number:~0,1%_CTTH_%shortfilename1%_FES_________.h5"://CTTH_HEIGHT %OutputDrive%\%OutputDir%\CTTH_theight_%shortfilename1%.mpr

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\CTTH_theight_%shortfilename1%'.mpr '%UtilDir%\fcc0000'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CTTH_height_%shortfilename1%'{dom=value;vr=0:25000:1}:=iff('%OutputDrive%\%OutputDir%\CTTH_theight_%shortfilename1%' gt 0,200*'%OutputDrive%\%OutputDir%\CTTH_theight_%shortfilename1%'+2000,?)


del "%OutputDrive%\%OutputDir%\CTTH_theight_%shortfilename1%.mpr.aux.xml"
del "%OutputDrive%\%OutputDir%\CTTH_theight_%shortfilename1%.mp*"



del "%OutputDrive%\%OutputDir%\SAFNWC_MSG%MSG_number:~0,1%_CTTH_%shortfilename1%_FES_________.h5"


:END
"%IlwDir%\ilwis.exe" -C closeall