@echo off 
echo Cloud Maks Import
echo Retrieve cloud, Dust and Volcanic mask
echo From Nowcasting SAF
echo For Northern portion MSG disk
rem Filename convention S_NWC_CMA_MSG2_MSG-N-VISIR_20200115T000000Z.nc



set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

set MSG_number=2


echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\S_NWC_CMA_MSG?_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" "%OutputDrive%\%OutputDir%\*.*"

set MSG_number=2
if exist "%InputDrive%\%InputDir%\S_NWC_CMA_MSG2_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" GOTO START

set MSG_number=3
if exist "%InputDrive%\%InputDir%\S_NWC_CMA_MSG3_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" GOTO START

set MSG_number=4

if not exist "%OutputDrive%\%OutputDir%\S_NWC_CMA_MSG4_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" goto MESSAGE


echo The file(s) "%InputDrive%\%InputDir%\S_NWC_CMA_MSG%MSG_number:~0,1%_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 


pause

GOTO END

:START
echo.
rem Cloud Mask
echo Retrieve Cloud Mask
echo.

"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"S_NWC_CMA_MSG%MSG_number:~0,1%_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc"://cma %OutputDrive%\%OutputDir%\CMa_maskv_%shortfilename1%%shortfilename2%.mpr
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\CMa_maskv_%shortfilename1%%shortfilename2%'.mpr '%UtilDir%\nwc_kuband'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CMa_cloud_value_%shortfilename1%%shortfilename2%'.mpr:=iff('%OutputDrive%\%OutputDir%\CMa_maskv_%shortfilename1%%shortfilename2%'=1,1,iff('%OutputDrive%\%OutputDir%\CMa_maskv_%shortfilename1%%shortfilename2%'=2,2,?))
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CMa_cloud_class_%shortfilename1%%shortfilename2%'.mpr{dom=nwc_cma1.dom}:=MapSlicing('%OutputDrive%\%OutputDir%\CMa_maskv_%shortfilename1%%shortfilename2%','%utildir%\nwc_cma1'.dom)

del "%OutputDrive%\%OutputDir%\CMa_maskv_%shortfilename1%%shortfilename2%.mpr.aux.xml"
del "%OutputDrive%\%OutputDir%\CMa_maskv_%shortfilename1%%shortfilename2%.mp*"


echo.
rem Dust Cloud Mask
echo Retrieve Dust Cloud Mask
echo.

"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"S_NWC_CMA_MSG%MSG_number:~0,1%_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc"://cma_dust %OutputDrive%\%OutputDir%\CMa_dustv_%shortfilename1%%shortfilename2%.mpr
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\CMa_dustv_%shortfilename1%%shortfilename2%'.mpr '%UtilDir%\nwc_kuband'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CMa_dust_%shortfilename1%%shortfilename2%'.mpr{dom=nwc_dust_vol1.dom}:=MapSlicing('%OutputDrive%\%OutputDir%\CMa_dustv_%shortfilename1%%shortfilename2%','%utildir%\nwc_dust_vol1'.dom)

del "%OutputDrive%\%OutputDir%\CMa_dustv_%shortfilename1%%shortfilename2%.mpr.aux.xml"
del "%OutputDrive%\%OutputDir%\CMa_dustv_%shortfilename1%%shortfilename2%.mp*"


echo.
rem Volcanic Cloud Mask
echo Retrieve Volcanic Cloud Mask
echo.

"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"S_NWC_CMA_MSG%MSG_number:~0,1%_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc"://cma_volcanic %OutputDrive%\%OutputDir%\CMa_volv_%shortfilename1%%shortfilename2%.mpr
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\CMa_volv_%shortfilename1%%shortfilename2%'.mpr '%UtilDir%\nwc_kuband'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CMa_volcanic_%shortfilename1%%shortfilename2%'.mpr{dom=nwc_dust_vol1.dom}:=MapSlicing('%OutputDrive%\%OutputDir%\CMa_volv_%shortfilename1%%shortfilename2%','%utildir%\nwc_dust_vol1'.dom)


del "%OutputDrive%\%OutputDir%\CMa_volv_%shortfilename1%%shortfilename2%.mpr.aux.xml"
del "%OutputDrive%\%OutputDir%\CMa_volv_%shortfilename1%%shortfilename2%.mp*"

del "%OutputDrive%\%OutputDir%\S_NWC_CMA_MSG%MSG_number:~0,1%_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc"
:END
"%IlwDir%\ilwis.exe" -C closeall