@echo off 
rem download setup_xrit2pic_cmd.exe from: http://www.alblas.demon.nl/wsat/software/winsoft_msg.html to tempory directory
rem download setup_gtk20dll.exe from: http://www.alblas.demon.nl/wsat/software/winsoft_msg.html to tempory directory
rem download setup_decompr.exe (JPEG and wvt decompression libs ) from: http://www.alblas.demon.nl/wsat/software/winsoft_msg.html to tempory directory

rem install xrit2pic_cmd to the same temp directory, repeat for setup_gtk20dll.exe - setup_decompr.exe and extract to the same directory

rem copy xrit2pic_cmd.exe and 16 dll files to your ilwis directory \Extensions\GEONETCast-Toolbox\util\xrit2pic


rem Polar orbit satellite tracks can be obained from: http://www.ssec.wisc.edu/datacenter/
rem select from the left hand menu the option: 'Polar Orbit Tracks'
rem select your satellite, e.g. NOAA 18, 19, Metop A (MO2) and 
rem select the region of interest, e.g. Europe, Africa, and
rem select the day and note the date-time of the overpass over your area of interest


rem files available in GEONETCast:
rem NOAA-LAC
rem sample file name avhrr_20140805_124000_noaa19.hrp.bz2 : 1 minute LAC data (2048 columns by 360 lines) 
rem start time of file required 

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set shortfilename2=%longfilename:~0,8%
set shortfilename3=%longfilename:~2,6%
set shortfilename4=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo avhrr_%shortfilename2%_%shortfilename4%00_noaa19.hrp.bz2

echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\avhrr_%shortfilename2%_%shortfilename4%00_noaa19.hrp.bz2" "%OutputDrive%\%OutputDir%\avhrr_%shortfilename2%_%shortfilename4%00_noaa19.hrp.bz2"

if not exist "%OutputDrive%\%OutputDir%\avhrr_%shortfilename2%_%shortfilename4%00_noaa19.hrp.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\avhrr_%shortfilename2%_%shortfilename4%00_noaa19.hrp.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END


:START

"%utildir%\7z" e avhrr_%shortfilename2%_%shortfilename4%00_noaa19.hrp.bz2

rem import data and transfer to pgm (Portable Gray Map Image) using xrit2pic_cmd.exe

"%UtilDir%\xrit2pic\xrit2pic_cmd.exe" -src "%OutputDrive%\%OutputDir%" -dest "%OutputDrive%\%OutputDir%" -overwrite -pgm >nul



rem Use gdal to export to ILWIS with following command (note day_time info as replacable parameter):

"%GdalDir%\gdal_translate.exe" -of ilwis Anoaa19_VIS006_%shortfilename3%_%shortfilename4%.pgm NOAA19_l_VIS006_%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis Anoaa19_VIS008_%shortfilename3%_%shortfilename4%.pgm NOAA19_l_VIS008_%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis Anoaa19_IR_039_%shortfilename3%_%shortfilename4%.pgm NOAA19_l_IR_039_%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis Anoaa19_IR_108_%shortfilename3%_%shortfilename4%.pgm NOAA19_l_IR_108_%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis Anoaa19_IR_120_%shortfilename3%_%shortfilename4%.pgm NOAA19_l_IR_120_%shortfilename1%.mpr



rem manualy create map list

copy "%UtilDir%\mpl_substitutename.bat" > nul
copy "%UtilDir%\NOAA19_L.mpl" > nul

cmd /c mpl_substitutename.bat ____ _%shortfilename1% NOAA19_L.mpl > NOAA19_L_%shortfilename1%.mpl



echo.
echo.
echo calculate day time colour composite, slight contribution of ir-39 channel
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\st1':=('%OutputDrive%\%OutputDir%\NOAA19_l_VIS006_%shortfilename1%'*'%OutputDrive%\%OutputDir%\NOAA19_l_VIS008_%shortfilename1%')/200
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\st2':=(('%OutputDrive%\%OutputDir%\st1'*3)+'%OutputDrive%\%OutputDir%\NOAA19_l_IR_039_%shortfilename1%')/4
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NOAA19_l_red':=MapStretchLinear('%OutputDrive%\%OutputDir%\st2'.mpr,150:2000,Image.dom,0:255)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NOAA19_l_green':=MapStretchLinear('%OutputDrive%\%OutputDir%\NOAA19_l_VIS008_%shortfilename1%'.mpr,0:1023,Image.dom,0:255)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NOAA19_l_blue':=MapStretchLinear('%OutputDrive%\%OutputDir%\NOAA19_l_VIS006_%shortfilename1%'.mpr,0:800,Image.dom,0:255)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NOAA19_l_rgb_%shortfilename1%'.mpr:=MapColorComp24Linear(mlist('%OutputDrive%\%OutputDir%\NOAA19_l_red','%OutputDrive%\%OutputDir%\NOAA19_l_green','%OutputDrive%\%OutputDir%\NOAA19_l_blue'),1.000000,1.000000,1.000000)



del Anoaa19_IR_*.pgm
del Anoaa19_VIS*.pgm
del NOAA19_l_IR_*.mpr.aux.xml
del NOAA19_l_VIS*.mpr.aux.xml
del noaa19_L.mpl
del mpl_substitutename.bat
del avhrr_%shortfilename2%_%shortfilename4%00_noaa19.hrp.bz2
del avhrr_%shortfilename2%_%shortfilename4%00_noaa19.hrp
del st1.mp*
del st2.mp*

del NOAA19_l_red.mp*
del NOAA19_l_green.mp*
del NOAA19_l_blue.mp*
del NOAA19_l_red.hi*
del NOAA19_l_green.hi*
del NOAA19_l_blue.hi*

:END
"%IlwDir%\ilwis.exe" -C closeall