@echo off

echo File name convention  S-OSI_-FRA_-MTOP-GLBSST_FIELD-201902110000Z.nc 
echo Date format expected is yyyymmddhhmm format
echo 2 times per day, at 00:00 and 12:00 UTC


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set shortfilename2=%longfilename:~0,8%
set shortfilename3=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDir%*

copy "%InputDrive%\%InputDir%\S-OSI_-FRA_-MTOP-GLBSST_FIELD-%shortfilename1%Z.nc" "%OutputDrive%\%OutputDir%\*.*"

if not exist "%OutputDrive%\%OutputDir%\S-OSI_-FRA_-MTOP-GLBSST_FIELD-%shortfilename1%Z.nc" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\S-OSI_-FRA_-MTOP-GLBSST_FIELD-%shortfilename1%Z.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"S-OSI_-FRA_-MTOP-GLBSST_FIELD-%shortfilename1%Z.nc"://sea_surface_temperature metop_sst%shortfilename1%1.mpr

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\metop_sst_temp%shortfilename1%.mpr{dom=value;vr=-100.00:100.00:0.001}:=iff(%OutputDrive%\%OutputDir%\metop_sst%shortfilename1%1 ge -1000, %OutputDrive%\%OutputDir%\metop_sst%shortfilename1%1/100,?)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\metop_sst_global%shortfilename1%.mpr:=MapMirrorRotate(%OutputDrive%\%OutputDir%\metop_sst_temp%shortfilename1%.mpr,MirrHor)


"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\metop_sst_global%shortfilename1%.mpr %utilDir%\metop_sst_global.grf


del metop_sst%shortfilename1%1.mp*
del metop_sst_temp%shortfilename1%.mp*
del S-OSI_-FRA_-MTOP-GLBSST_FIELD-%shortfilename1%Z.nc



:END
"%IlwDir%\ilwis.exe" -C closeall