@echo off
echo CLA-import
echo Merging of files (type BUFR)
echo Phase, amount of low, middle and high clouds per segment is transformed into a grid map
echo For the undefined grid no information is available from the source bufr data file
echo Use is made of the MSG projection
echo.
echo Cloud Analysis BUFR Import and Processing
echo Note that import can take some time as large number of record need to be processed
echo Be patient as various columns in a table are being calculated
echo After routine has completed display the point and raster maps created
echo For quick visualization of the CLA file use BUFRdisplay
echo Relevant coordinate variables are: 14-latitude (code 5001), 15-longitude (code 6001)
echo Relevant parameters are: 17-Amount_Low_clouds (code 20051), 34-Amount_Mid_Clouds (code 20052) and 51-Amount_High_Clouds (code 20053)
echo Relevant parameters are: 26-Cloud_Phase (2nd_Low Cloud), 43-Cloud_Phase (2nd_Mid Cloud) and 60-Cloud_Phase (2nd_High Cloud)
echo From each level only the 2nd layer for phase is retrieved!
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

set MSG_number=2


copy "%InputDrive%\%InputDir%\L-000-MSG?__-MPEF________-Cla______-00000?___-%shortfilename1%-__*.*" 

if exist "%OutputDrive%\%OutputDir%\L-000-MSG2__-MPEF________-Cla______-00000?___-%shortfilename1%-__*.*" GOTO START1

set MSG_number=3

if exist "%OutputDrive%\%OutputDir%\L-000-MSG3__-MPEF________-Cla______-00000?___-%shortfilename1%-__*.*" GOTO START1

set MSG_number=4

:START1
if not exist "%InputDrive%\%InputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF________-Cla______-00000?___-%shortfilename1%-__*.*"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\L-000-MSG%MSG_number:~0,1%__-MPEF________-Cla______-00000?___-%shortfilename1%-__" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\joinmsg.exe" "L-000-MSG%MSG_number:~0,1%__-MPEF________-Cla______-000001___-%shortfilename1%-__" %OutputDrive%\%OutputDir%\

ren L-000-MSG?__-MPEF________-Cla______-000001___-%shortfilename1%-__.xyz cla%shortfilename1%.bufr



echo.
echo.
echo Renamed input file = cla%shortfilename1%.bufr
echo.
echo.




copy cla%shortfilename1%.bufr "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract" > NUL

cd /d "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract"

bufrextract.exe cla%shortfilename1%.bufr -oddump.csv > mess.txt 2>&1

cd /d "%OutputDrive%\%OutputDir%"

copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv" > NUL

del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\cla%shortfilename1%.bufr"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\mess.txt"

findstr /b /v "0" dump.csv > dump1.csv
findstr /b /v "#" dump1.csv > dump2.csv 


copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\ConvertCSV.class 

java ConvertCSV 16 15 18 27 35 44 52 61 < dump2.csv > dump3.csv 


echo off
echo.
echo.
echo Importing data from BUFR file into ILWIS and create output maps
echo Calculation of amount of low, mid and high level clouds / cloud phase per level (2nd level)
echo Wait till routine completes, this can take some time 
echo.



"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\cla%shortfilename1%'.tbt:=table('%OutputDrive%\%OutputDir%\dump3'.csv,Comma,Convert,none,X(value.dom{-90:90:0.00001}),Y(value.dom{-90:90:0.00001}),Perc_low(value.dom{0:101:1}),phase_low(value.dom{0:5:1}),Perc_mid(value.dom{0:101:1}),phase_mid(value.dom{0:5:1}),Perc_high(value.dom{0:101:1}),phase_high(value.dom{0:5:1}))

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\cla_phase_points%shortfilename1%'.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\cla%shortfilename1%',X,Y,LatlonWGS84,phase_mid)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\cla_phase_grid%shortfilename1%'.mpr{dom=value;vr=0:5:1}:=MapRasterizePoint('%OutputDrive%\%OutputDir%\cla_phase_points%shortfilename1%','%UtilDir%\msg_0degree_3km'.grf,16)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\Cla_phase_mid_%shortfilename1%'.mpr{dom='%UtilDir%\cla_mid'}:=MapSlicing('%OutputDrive%\%OutputDir%\CLA_phase_grid%shortfilename1%'.mpr,'%UtilDir%\cla_mid');


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\cla_low_points%shortfilename1%'.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\cla%shortfilename1%',X,Y,LatlonWGS84,perc_low)

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\cla_low_grid%shortfilename1%'.mpr{dom=value;vr=0:101:1}:=MapRasterizePoint('%OutputDrive%\%OutputDir%\cla_low_points%shortfilename1%','%UtilDir%\msg_0degree_3km'.grf,16)

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\cla_mid_points%shortfilename1%'.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\cla%shortfilename1%',X,Y,LatlonWGS84,perc_mid)

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\cla_mid_grid%shortfilename1%'.mpr{dom=value;vr=0:101:1}:=MapRasterizePoint('%OutputDrive%\%OutputDir%\cla_mid_points%shortfilename1%','%UtilDir%\msg_0degree_3km'.grf,16)

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\cla_high_points%shortfilename1%'.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\cla%shortfilename1%',X,Y,LatlonWGS84,perc_high)

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\cla_high_grid%shortfilename1%'.mpr{dom=value;vr=0:101:1}:=MapRasterizePoint('%OutputDrive%\%OutputDir%\cla_high_points%shortfilename1%','%UtilDir%\msg_0degree_3km'.grf,16)


del l-000-MSG?__-mpef________-cla______-00000?___-%shortfilename1%-*.*
del cla_phase_grid%shortfilename1%.mp*
del cla%shortfilename1%.bufr
del dump*.csv
del ConvertCSV.class



:END
"%IlwDir%\ilwis.exe" -C closeall



