@echo off
echo HSAF MPEG-import
echo temporal resolution 15 minutes
echo Output is a value map in mm/hr 
echo file name expected is S-HSAF-h03B_20190205_0000_fdk.grb.gz




set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%




copy "%InputDrive%\%InputDir%\S-HSAF-h03B_%shortfilename1%_%shortfilename2%_fdk.grb.gz" 


if not exist "%InputDrive%\%InputDir%\S-HSAF-h03B_%shortfilename1%_%shortfilename2%_fdk.grb.gz"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-HSAF-h03B_%shortfilename1%_%shortfilename2%_fdk.grb.gz" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-HSAF-h03B_%shortfilename1%_%shortfilename2%_fdk.grb.gz
"%gdalDir%\gdal_translate.exe" -of ilwis "h03B_%shortfilename1%_%shortfilename2%_fdk.grb" %OutputDrive%\%OutputDir%\h03B_%shortfilename1%_%shortfilename2%.mpr


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\MPEG_H03B_%shortfilename1%%shortfilename2%'.mpr{dom=value;vr=0:100:0.00001}:=iff('%OutputDrive%\%OutputDir%\h03B_%shortfilename1%_%shortfilename2%_band_1' gt 0,'%OutputDrive%\%OutputDir%\h03B_%shortfilename1%_%shortfilename2%_band_1'*3600,?)
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\MPEG_H03B_%shortfilename1%%shortfilename2%'.mpr '%UtilDir%\msg_0degree_3km'




del h03B_%shortfilename1%_%shortfilename2%.mpl
del h03B_%shortfilename1%_%shortfilename2%.grf
del h03B_%shortfilename1%_%shortfilename2%.csy
del h03B_%shortfilename1%_%shortfilename2%.mpr.aux*
del h03B_%shortfilename1%_%shortfilename2%_band_?.mp*
del S-HSAF-h03B_%shortfilename1%_%shortfilename2%_fdk.grb.gz
del h03B_%shortfilename1%_%shortfilename2%_fdk.grb

:END
"%IlwDir%\ilwis.exe" -C closeall