@echo off
echo GMI L1C Brightness Temperature-import BUFR Import and Processing - S1
echo GMI L1C Brightness Temperature - S1
echo BUFR file with L1C data from the GMI instrument on the GPM-Core satellite
echo 5 minutes each
echo file name convention channel 1 is W_XX-EUMETSAT-Darmstadt,SOUNDING+SATELLITE,GPM+GMI+S1_C_EUMP_201509151336_133640_134138_L1C.bin.bz2
echo file name convention channel 1 is W_XX-EUMETSAT-Darmstadt,SOUNDING+SATELLITE,GPM+GMI+S1_C_EUMP_202004071411_141140_141638_L1C.bin.bz2
echo Relevant coordinate variables are: 20-latitude , 21-longitude  
echo And as parameter 28, 35, 42, 49, 56, 63, 70, 77, 84 -Brightness Temperatures (K) in different frequencies / polarizations
echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%


copy "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SOUNDING+SATELLITE,GPM+GMI+S1_C_EUMP_%1*_L1C.bin.bz2" 

if exist "%OutputDrive%\%OutputDir%\W_XX-EUMETSAT-Darmstadt,SOUNDING+SATELLITE,GPM+GMI+S1_C_EUMP_%1*_L1C.bin.bz2" GOTO START


:START
if not exist "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SOUNDING+SATELLITE,GPM+GMI+S1_C_EUMP_%1*_L1C.bin.bz2"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SOUNDING+SATELLITE,GPM+GMI+S1_C_EUMP_%1*_L1C.bin.bz2" will be copied to your current working directory
echo.
echo.

GOTO START


:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

rename "W_XX-EUMETSAT-Darmstadt,SOUNDING+SATELLITE,GPM+GMI+S1_C_EUMP_%1*_L1C.bin.bz2" GMI%shortfilename1%.bin.bz2

"%UtilDir%\7z" e GMI%shortfilename1%.bin.bz2

copy GMI%shortfilename1%.bin "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract" >NUL

cd /d "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract"

bufrextract.exe GMI%shortfilename1%.bin -oddump.csv > mess.txt 2>&1

cd /d "%OutputDrive%\%OutputDir%"

copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv" >NUL

del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\dump.csv"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\GMI%shortfilename1%.bin"
del "%IlwDir%\Extensions\GEONETCast-Toolbox\util\bufrextract\mess.txt"

findstr /b /v "0" dump.csv > dump1.csv
findstr /b /v "#" dump1.csv > dump2.csv 


copy "%IlwDir%\Extensions\GEONETCast-Toolbox\util\ConvertCSV.class 

java ConvertCSV 21 20 28 35 42 49 56 63 70 77 84 < dump2.csv > dump3.csv 



"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\GPM_GMI_S1_%shortfilename1%.tbt:=table(%OutputDrive%\%OutputDir%\dump3.csv,Comma,Convert,none,X(value.dom{-180:180:1e-005}),Y(value.dom{-90:90:1e-005}),BT1_10_7Ghz_Ver(value.dom{0:500:0.1}),BT2_10_7Ghz_Hor(value.dom{0:500:0.1}),BT3_18_7Ghz_Ver(value.dom{0:500:0.1}),BT4_18_7Ghz_Hor(value.dom{0:500:0.1}),BT5_23_8Ghz_Ver(value.dom{0:500:0.1}),BT6_36_5Ghz_Ver(value.dom{0:500:0.1}),BT7_36_5Ghz_Hor(value.dom{0:500:0.1}),BT8_89Ghz_Ver(value.dom{0:500:0.1}),BT9_89Ghz_Hor(value.dom{0:500:0.1}))

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\GPM_GMI_S1_%shortfilename1%_BT1_10_7Ghz_Ver.mpp:=PointMapFromTable(%OutputDrive%\%OutputDir%\GPM_GMI_S1_%shortfilename1%,X,Y,LatlonWGS84,BT1_10_7Ghz_Ver)

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\GPM_GMI_S1_BT1_10_7Ghz_Ver{dom=value;vr=0:1000:0.1}:=MapRasterizePoint(%OutputDrive%\%OutputDir%\GPM_GMI_S1_%shortfilename1%_BT1_10_7Ghz_Ver,'%UtilDir%\gpm_2_5min'.grf,1)


del dump*.csv
del GMI*.bin.bz2
del GMI*.bin
del ConvertCSV.class

:END
"%IlwDir%\ilwis.exe" -C closeall