@echo off

rem Himawari-8 import
rem 10 blocks are required - of 550 lines and 5500 columns each
rem all can have different header size
rem java application ReadHimawariHeader.java and ReadHimawariHeader.class are used to read header size
rem data blocks are imported in ilwis, with known header size for each block
rem subsequently all data blocks are merged into temporary single file
rem dummy mpr is used 
rem finally coordinate and georeference info is assigned
rem file name convention is IMG_DK01VIS_201701270000_001.bz2 for VIS band only
rem file name convention is IMG_DK01IR1_201701270000_001.bz2 to IMG_DK01IR4_201701271305_006.bz2, for bands IR1, IR2, IR3 and IR4
rem file name convention is IMG_DK01B04_201701270000_001.bz2 to IMG_DK01B16_201701270000_001.bz2, for bands 04, 05, 06, 09, 10, 11, 14, 16




set longfilename=%1
set shortfilename1=%longfilename:~0,16%
set shortfilename2=%longfilename:~0,11%
set shortfilename3=%longfilename:~12,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDrive%\%OutputDir%*
echo import VIS image

copy "%InputDrive%\%InputDir%\IMG_DK01VIS_%shortfilename2%?_0??.bz2

if not exist "%OutputDrive%\%OutputDir%\IMG_DK01VIS_%shortfilename2%?_001.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\IMG_DK01VIS_%shortfilename2%?_0??.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z.exe" e IMG_DK01VIS_%shortfilename2%?_0??.bz2
copy "%UtilDir%\ReadHimawariHeader.*" >NUL

echo Visible channel - band 3 is imported - wait till routine is completed
echo unit is albedo in percentage from 0 to 100
echo linear conversion applied 0:=-0.10 to 
1023:=100.00

rem read header size and import block

rem for block1
rename IMG_DK01VIS_%shortfilename2%?_001 IMG_DK01VIS_%shortfilename2%0_001
java ReadHimawariHeader IMG_DK01VIS_%shortfilename2%0_001 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)

set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block01:=map(IMG_DK01VIS_%shortfilename2%0_001,genras,Convert,5500,%hsize%,Int,2,Swap)


rem for block2
rename IMG_DK01VIS_%shortfilename2%?_002 IMG_DK01VIS_%shortfilename2%0_002
java ReadHimawariHeader IMG_DK01VIS_%shortfilename2%0_002 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)

set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block02:=map(IMG_DK01VIS_%shortfilename2%0_002,genras,Convert,5500,%hsize%,Int,2,Swap)


rem for block3
rename IMG_DK01VIS_%shortfilename2%?_003 IMG_DK01VIS_%shortfilename2%0_003
java ReadHimawariHeader IMG_DK01VIS_%shortfilename2%0_003 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)

set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block03:=map(IMG_DK01VIS_%shortfilename2%0_003,genras,Convert,5500,%hsize%,Int,2,Swap)

rem for block4
rename IMG_DK01VIS_%shortfilename2%?_004 IMG_DK01VIS_%shortfilename2%0_004
java ReadHimawariHeader IMG_DK01VIS_%shortfilename2%0_004 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)

set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block04:=map(IMG_DK01VIS_%shortfilename2%0_004,genras,Convert,5500,%hsize%,Int,2,Swap)


rem for block5
rename IMG_DK01VIS_%shortfilename2%?_005 IMG_DK01VIS_%shortfilename2%0_005
java ReadHimawariHeader IMG_DK01VIS_%shortfilename2%0_005 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)

set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block05:=map(IMG_DK01VIS_%shortfilename2%0_005,genras,Convert,5500,%hsize%,Int,2,Swap)


rem for block6
rename IMG_DK01VIS_%shortfilename2%?_006 IMG_DK01VIS_%shortfilename2%0_006
java ReadHimawariHeader IMG_DK01VIS_%shortfilename2%0_006 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)

set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block06:=map(IMG_DK01VIS_%shortfilename2%0_006,genras,Convert,5500,%hsize%,Int,2,Swap)


rem for block7
rename IMG_DK01VIS_%shortfilename2%?_007 IMG_DK01VIS_%shortfilename2%0_007
java ReadHimawariHeader IMG_DK01VIS_%shortfilename2%0_007 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)

set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block07:=map(IMG_DK01VIS_%shortfilename2%0_007,genras,Convert,5500,%hsize%,Int,2,Swap)


rem for block8
rename IMG_DK01VIS_%shortfilename2%?_008 IMG_DK01VIS_%shortfilename2%0_008
java ReadHimawariHeader IMG_DK01VIS_%shortfilename2%0_008 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)

set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block08:=map(IMG_DK01VIS_%shortfilename2%0_008,genras,Convert,5500,%hsize%,Int,2,Swap)


rem for block9
rename IMG_DK01VIS_%shortfilename2%?_009 IMG_DK01VIS_%shortfilename2%0_009
java ReadHimawariHeader IMG_DK01VIS_%shortfilename2%0_009 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)

set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block09:=map(IMG_DK01VIS_%shortfilename2%0_009,genras,Convert,5500,%hsize%,Int,2,Swap)


rem for block10
rename IMG_DK01VIS_%shortfilename2%?_010 IMG_DK01VIS_%shortfilename2%0_010
java ReadHimawariHeader IMG_DK01VIS_%shortfilename2%0_010 >hsize.txt

setlocal enabledelayedexpansion
set i=1
for /f "tokens=*" %%a in ('type hsize.txt') do (
  set Line!i!=%%a
  set /a i+=1
)

set hsize=
set hsize=%Line1% 
rem echo header size of this segment is %hsize%  
"%IlwDir%\ilwis.exe" -C block10:=map(IMG_DK01VIS_%shortfilename2%0_010,genras,Convert,5500,%hsize%,Int,2,Swap)


rem merge all blocks into single file
copy /y /b block01.mp#+block02.mp#+block03.mp#+block04.mp#+block05.mp#+block06.mp#+block07.mp#+block08.mp#+block09.mp#+block10.mp# him8_%longfilename:~0,12%_temp.mp# >NUL


rem set georeference and coordinate system for himawari_8
copy "%UtilDir%\him_8allb.mpr" >NUL
copy "%UtilDir%\mpl_substitutename.bat" >NUL

cmd /c mpl_substitutename.bat ____ him8_%longfilename:~0,12%_temp him_8allb.mpr > him8_%longfilename:~0,12%_temp.mpr


"%IlwDir%\ilwis.exe" -C setgrf 'him8_%longfilename:~0,12%_temp'.mpr 'UtilDir\himawari_8'.grf

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\him8_%longfilename:~0,12%_visb3'.mpr{dom=value;vr=0.00:100.00:0.01}:='him8_%longfilename:~0,12%_temp'*0.097751711



rem delete obsolete files
del hsize.txt
del him_8allb.mpr" 
del mpl_substitutename.bat
del ReadHimawariHeader.*
del IMG_DK01VIS_%shortfilename2%?_0??.*
del block??.mp*
del him8_%longfilename:~0,12%_temp.mp*


:END
"%IlwDir%\ilwis.exe" -C closeall