@echo off & setlocal enableextensions

rem copy 6 files based on end overpass-time
rem for METOP A EARS HRP
rem M02 Instrument
rem first 2 digits of year are removed to cope with 32 bit OS limitation


set longfilename=%1
set shortfilename1=%longfilename:~2,10%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
set irfanviewdir=%9


cd\
%OutputDrive%
cd %OutputDir%


echo *%outputDrive%\%OutputDir%*

rem timestep 0 retrieval
if not exist "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%shortfilename1%*.bz2" goto END
copy "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%shortfilename1%*.bz2" >nul
echo file retrieved for 20%longfilename:~2,10%


rem timestep 1 retrieval
set /a time1=%shortfilename1% - 1 
if %time1:~8,2% GEQ 60 (
set /a time1=%shortfilename1%-40-1
)
if not exist "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%time1%*.bz2" goto END
copy "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%time1%*.bz2" >nul
echo file retrieved for 20%time1%


rem timestep 2 retrieval
set /a time2=%shortfilename1% - 2 
if %time2:~8,2% GEQ 60 (
set /a time2=%shortfilename1%-40-2
)
if not exist "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%time2%*.bz2" goto END
copy "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%time2%*.bz2" >nul
echo file retrieved for 20%time2%


rem timestep 3 retrieval
set /a time3=%shortfilename1% - 3 
if %time3:~8,2% GEQ 60 (
set /a time3=%shortfilename1%-40-3
)
if not exist "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%time3%*.bz2" goto END
copy "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%time3%*.bz2" >nul
echo file retrieved for 20%time3%


rem timestep 4 retrieval
set /a time4=%shortfilename1% - 4 
if %time4:~8,2% GEQ 60 (
set /a time4=%shortfilename1%-40-4
)
if not exist "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%time4%*.bz2" goto END
copy "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%time4%*.bz2" >nul
echo file retrieved for 20%time4%


rem timestep 5 retrieval
set /a time5=%shortfilename1% - 5 
if %time5:~8,2% GEQ 60 (
set /a time5=%shortfilename1%-40-5
)
if not exist "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%time5%*.bz2" goto END
copy "%InputDrive%\%InputDir%\AVHR_HRP_00_M02_20%time5%*.bz2" >nul
echo file retrieved for 20%time5%

rem further processing 

"%UtilDir%\7z.exe" e AVHR_HRP_00_M02_20*.bz2 >nul
del "%outputDrive%\%OutputDir%\AVHR_HRP_00_M02_20*.bz2"
"%UtilDir%\xrit2pic\xrit2pic_cmd.exe" -src "%outputDrive%\%OutputDir%" -dest "%outputDrive%\%OutputDir%" -overwrite -pgm >nul

del "%outputDrive%\%OutputDir%\AVHR_HRP_00_M02_*"



set endscanyymmdd=%time5:~0,6%
set endscanhhmm=%time5:~6,4%

ren Mmetop-A_IR_108_%endscanyymmdd%_%endscanhhmm%.pgm MetopA_ir_108_20%shortfilename1%.pgm
ren Mmetop-A_IR_120_%endscanyymmdd%_%endscanhhmm%.pgm MetopA_ir_120_20%shortfilename1%.pgm
ren Mmetop-A_IR_039_%endscanyymmdd%_%endscanhhmm%.pgm MetopA_ir_039_20%shortfilename1%.pgm
ren Mmetop-A_VIS008_%endscanyymmdd%_%endscanhhmm%.pgm MetopA_vis008_20%shortfilename1%.pgm
ren Mmetop-A_VIS006_%endscanyymmdd%_%endscanhhmm%.pgm MetopA_vis006_20%shortfilename1%.pgm


rem Use gdal to export to ILWIS with following command (note day_time info as replacable parameter):

"%GdalDir%\gdal_translate.exe" -of ilwis MetopA_vis006_20%shortfilename1%.pgm METOP_A_VIS006_20%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis MetopA_vis008_20%shortfilename1%.pgm METOP_A_VIS008_20%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis MetopA_ir_039_20%shortfilename1%.pgm METOP_A_IR_039_20%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis MetopA_ir_108_20%shortfilename1%.pgm METOP_A_IR_108_20%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis MetopA_ir_120_20%shortfilename1%.pgm METOP_A_IR_120_20%shortfilename1%.mpr


rem create map list

copy "%UtilDir%\mpl_substitutename.bat" > nul
copy "%UtilDir%\ears_metopA.mpl" > nul

cmd /c mpl_substitutename.bat ____ _20%shortfilename1% ears_metopA.mpl > EARS_MetopA_20%shortfilename1%.mpl


echo.
echo.
echo create day time colour composite red=vis006, green=vis008 and blue=ir108
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\metop_red'.mpr{dom=image.dom;vr=0:255}:=MapStretchLinear('%OutputDrive%\%OutputDir%\METOP_A_VIS006_20%shortfilename1%'.mpr,1.000000,image.dom)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\metop_green'.mpr{dom=image.dom;vr=0:255}:=MapStretchLinear('%OutputDrive%\%OutputDir%\METOP_A_VIS008_20%shortfilename1%'.mpr,1.000000,image.dom)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\metop_blue'.mpr{dom=image.dom;vr=0:255}:=MapStretchLinear('%OutputDrive%\%OutputDir%\METOP_A_IR_108_20%shortfilename1%'.mpr,1.000000,image.dom)
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\EARS_MetopA_fcc_20%shortfilename1%'.mpr:=MapColorComp24Linear(mlist('%OutputDrive%\%OutputDir%\metop_red','%OutputDrive%\%OutputDir%\metop_green','%OutputDrive%\%OutputDir%\metop_blue'),1.000000,1.000000,1.000000)


rem export to tif and display using irfanview 

"%IlwDir%\ilwis.exe" -C export tiff('%OutputDrive%\%OutputDir%\EARS_MetopA_fcc_20%shortfilename1%'.mpr,'%OutputDrive%\%OutputDir%\EARS_MetopA_20%shortfilename1%'.tif)

"%UtilDir%\IrfanView\i_view32.exe" "%OutputDrive%\%OutputDir%\EARS_MetopA_20%shortfilename1%.tif" /hide=15 /hflip /vflip



del METOPA_IR_*.pgm
del METOPA_VIS*.pgm
del METOP_A_IR_*.mpr.aux.xml
del METOP_A_VIS*.mpr.aux.xml
del ears_metopA.mpl
del mpl_substitutename.bat
del metop_blue.mp*
del metop_green.mp*
del metop_red.mp*
del metop_blue.hi*
del metop_green.hi*
del metop_red.hi*
del EARS_MetopA_fcc_20%shortfilename1%.mp*

GOTO FINAL

:END
echo Not all files required are available
if exist "%outputDrive%\%OutputDir%\AVHR_HRP_00_M02_*.bz2" del "%outputDrive%\%OutputDir%\AVHR_HRP_00_M02_*.bz2"
pause

:FINAL

