import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.sun.org.apache.xpath.internal.XPathAPI;

public class ConvertFIRC {

	/**
	 * @param args
	 * @throws ParserConfigurationException
	 * @throws IOException
	 * @throws SAXException
	 * @throws TransformerException
	 */
	public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException, TransformerException {
		if (args.length == 1) {
			String inputFile = args[0];
			FileInputStream xmlInputStream = new FileInputStream(inputFile);
			if (xmlInputStream.markSupported()) { // trim whitespace left by joinmsg.exe
				xmlInputStream.mark(256);
				char c = (char) (xmlInputStream.read());
				while (c != '<') {
					xmlInputStream.mark(256);
					c = (char) (xmlInputStream.read());
				}
				xmlInputStream.reset();
			} else {
				xmlInputStream.skip(1);

			}
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document doc = builder.parse(xmlInputStream);
			NodeList records = XPathAPI.selectNodeList(doc, "//info");
			int len = records.getLength();
			for (int i = 0; i < len; ++i) {
				Node record = records.item(i);
				Node certainty = XPathAPI.selectSingleNode(record, "certainty");
				String certaintyText = certainty != null ? certainty.getTextContent() : null;
				int lastDot = inputFile.lastIndexOf('.');
				String outputFileName = inputFile.substring(0, lastDot) + certaintyText + ".csv";
				BufferedWriter bw = new BufferedWriter(new FileWriter(outputFileName));
				NodeList points = XPathAPI.selectNodeList(record, "area/circle");
				int nrPoints = points.getLength();
				System.out.println("Writing " + nrPoints + " points into " + certaintyText);
				for (int j = 0; j < nrPoints; ++j) {
					Node point = points.item(j);
					String pointText = (point != null) ? point.getTextContent() : null;
					String[] elements = pointText.split(",| ");
					String csvLine = "";
					for (String element : elements)
						csvLine += ((csvLine.length() > 0) ? "," : "") + element;
					bw.write(csvLine + "\n");
				}
				bw.flush();
				bw.close();
				bw = null;
			}
		} else {
			System.out.println("ConvertFIRC extracts all records from a FIRC file, and stores them as CSV files.");
			System.out.println("FIRC files originating from Geonetcast must first be processed by joinmsg.exe .");
			System.out.println("The number of output files depends on the number of reports in the FIRC file.");
			System.out.println("The filename of the output files uses the same base filename as the input file,");
			System.out.println("and the certainty of the record is appended to the filename.");
			System.out.println("The resulting files are placed in the same folder as the source file");
			System.out.println("Any existing files in the same folder with the same name are overwritten.");
			System.out.println("Usage: java ConvertFIRC <input_file>");
			System.out.println("Example: java ConvertFIRC l-000-msg2__-mpef________-firc_____-000001___-201209200915-__.xyz");
		}
	}
}
