import java.awt.Toolkit;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class DataManager {

	static final String CONFIG_FILE = "DataManager.txt";
	static final String APPLICATION_ICON = "DataManager.png";
	static final String EXIT_APPLICATION = "Exit please";
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			setNativeLookAndFeel();
			String config = CONFIG_FILE;
			boolean autostart = false;
			if (args.length > 0) {
				String parameterConfigFile = args[0];
				File file = new File(parameterConfigFile);
				if (file.exists()) {
					config = parameterConfigFile;
					autostart = true;
				} else
					config = askConfigFile(parameterConfigFile);					
			} else
				config = askConfigFile(config);
			if (config.compareTo(EXIT_APPLICATION) != 0) {
				ConfigFile configFile = new ConfigFile(config);
				GeneralConfig generalConfig = new GeneralConfig(configFile);
				JFrame frame = new JFrame(generalConfig.getTitle());
				JButton actionButton = generalConfig.addToPanel(frame);
				frame.pack();
				frame.setLocationByPlatform(true);
		        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		        if (new File(APPLICATION_ICON).exists())
		        	frame.setIconImage(Toolkit.getDefaultToolkit().getImage(APPLICATION_ICON));
		        else {
		        	try {
		        		frame.setIconImage(Toolkit.getDefaultToolkit().getImage(configFile.getClass().getResource(APPLICATION_ICON)));
		        	} catch (NullPointerException e) {
		        		System.out.println("Could not load icon " + APPLICATION_ICON);
		        	}
		        }
		        frame.setVisible(true);
		        if (autostart) {
		        	int autostartDelay = generalConfig.getAutostartDelay();
		        	actionButton.setText("Autostart " + autostartDelay);
					actionButton.setEnabled(false);
		        	Thread.sleep(1000 * autostartDelay);
		        	actionButton.setEnabled(true);
		        	actionButton.setText("Start");
		        	actionButton.doClick();
		        }
			}
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
	}
	
	private static String askConfigFile(String defaultFile) {		
		JFileChooser chooser = new JFileChooser();
		File file = new File(defaultFile);
		chooser.setSelectedFile(file.getAbsoluteFile());		
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		int returnVal = chooser.showOpenDialog(null);
	    if(returnVal == JFileChooser.APPROVE_OPTION)
	        return chooser.getSelectedFile().getAbsolutePath();
	    else
	    	return EXIT_APPLICATION;

	}
	
	private static void setNativeLookAndFeel() {
		String nativeLF = UIManager.getSystemLookAndFeelClassName();
		// Install the look and feel
		try {
			UIManager.setLookAndFeel(nativeLF);
		} catch (InstantiationException e) {
		} catch (ClassNotFoundException e) {
		} catch (UnsupportedLookAndFeelException e) {
		} catch (IllegalAccessException e) {
		}
	}
}
