import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class ConfigFile {
	private List<String> lines;
	private int currentPos;
	private int size;
	private File file;
	
	public ConfigFile(String fileName) {
		this.file = new File(fileName);
		if (!this.file.exists()) {
			String myJar = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString().substring(5);
			while (myJar.startsWith("/"))
				myJar = myJar.substring(1);
			// myDir = "C:/Documents%20and%20Settings/retsios.WINDOWSNT/Application%20Data/Sun/Java/Deployment/cache/javaws/file/Dlocalhost/P-1/DMc&c/RMShellExec.jar";
			myJar = urldecode(myJar);
			File dir = new File(myJar);
			if (!dir.isDirectory())
				dir = dir.getParentFile();
			File tryFile = new File(dir, fileName);
			if (tryFile.exists())
				this.file = tryFile;
		}
		lines = new ArrayList<String>();
		try {
			InputStream ist = new FileInputStream(fileName);
			BufferedReader istream = new BufferedReader(new InputStreamReader(
					ist));
			String line = istream.readLine();
			while (line != null) {
				if (!line.trim().startsWith("#")
						&& !(line.trim().length() == 0))
					lines.add(line.trim());
				line = istream.readLine();
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
		}
		size = lines.size();
		currentPos = 0;
	}
	
	private String readLine() {
		if (currentPos < size)
			return lines.get(currentPos++);
		else
			return null;
	}
	
	private String readNextNonemptyLine() {
		String line = readLine();
		while (line != null && line.trim().length() == 0)
			line = readLine();
		if (line == null)
			return null;
		else
			return line.trim();
	}

	public int nrLines() {
		return size;
	}
	
	public boolean eof() {
		return currentPos >= size;
	}

	public String readToken(String tokenName, String defaultValue) {
		int oldPos = currentPos;
		String line = readNextNonemptyLine();
		if ((line == null) || (!startsWithIgnoreCase(line, tokenName))) {
			currentPos = oldPos;
			return defaultValue;
		}
		return line.substring(tokenName.length()).trim(); 
	}

	private boolean startsWithIgnoreCase(String line, String tokenName) {
		return line.toLowerCase().startsWith(tokenName.toLowerCase());
	}
	
	public void writeToken(String tokenName, String value, String defaultValue) {
		if ((defaultValue == null) || (value.compareTo(defaultValue) != 0))
			lines.add(tokenName + "\t" + value);
		else
			lines.add("# " + tokenName + "\t" + value);
		++size;
		++currentPos;
	}
	
	public void writeln() {
		lines.add("");
		++size;
		++currentPos;
	}
	
	public void newFile() {
		lines.clear();
		size = 0;
		currentPos = 0;
	}
	
	public void rewind() {
		currentPos = 0;
	}
	
	public void store() {
		try {
			OutputStream ost = new FileOutputStream(file);
			BufferedWriter ostream = new BufferedWriter(new OutputStreamWriter(
					ost));
			for (String line : lines) {
				ostream.write(line);
				ostream.newLine();
			}
			ostream.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
		}
	}
	
	private static String urldecode(String in) {
		StringBuffer out = new StringBuffer(in.length());
		int i = 0;
	
		while (i < in.length()) {
			char ch = in.charAt(i);
			i++;
			if (ch == '+')
				ch = ' ';
			else if (ch == '%') {
				ch = (char) Integer.parseInt(in.substring(i, i + 2), 16);
				i += 2;
			}
			out.append(ch);
		}
		return new String(out);
	}

}
