import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class ActivityMonitor {
	
	private final JTextField activityText;
	private final JProgressBar progressBar;
	
	private int pos;

	public ActivityMonitor(JProgressBar progressBar, JTextField activityText) {
		this.progressBar = progressBar;
		this.activityText = activityText;
		this.progressBar.setMinimum(0);
		this.progressBar.setMaximum(1);
		pos = 0;
		this.progressBar.setValue(pos);
	}

	public void startJob(String text) {
		this.activityText.setText(text);		
	}

	public void endJob() {
		this.activityText.setText("");
		this.progressBar.setValue(0);
		this.progressBar.setStringPainted(false);
	}

	public void startJob(String text, int steps) {
		this.activityText.setText(text);
		this.progressBar.setMaximum(steps);
		pos = 0;
		this.progressBar.setValue(pos);
		progressBar.setStringPainted(true);
	}
	
	public void work() {
		++pos;
		progressBar.setValue(pos);
	}
}
