/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util;

import gov.nasa.giss.util.EasyXmlParser;
import gov.nasa.giss.util.PropertyNotFoundException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Objects;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyList {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Hashtable<String, PropertyList> bundles_ = new Hashtable();
    private Class<?> tclass_;
    private Hashtable<String, Object[]> phash_;
    private String resourceID_;

    public static PropertyList getBundle(String bname) {
        PropertyList bundle;
        block3: {
            LOGGER.trace("{}", (Object)bname);
            if (bundles_.containsKey(bname)) {
                return bundles_.get(bname);
            }
            bundle = null;
            try {
                bundle = new PropertyList(bname);
                bundles_.put(bname, bundle);
            }
            catch (Exception exc) {
                LOGGER.error("IOException getting bundle {}", (Object)bname);
                if (!LOGGER.isTraceEnabled()) break block3;
                exc.printStackTrace();
            }
        }
        return bundle;
    }

    public PropertyList(String bname) {
        this(bname, Locale.getDefault());
    }

    public PropertyList(String bpath, String bname) {
        this(bpath + bname, Locale.getDefault());
    }

    public PropertyList(String bname, Locale locale) {
        LOGGER.trace("{}, {}", (Object)bname, (Object)locale);
        Objects.requireNonNull(bname, "Bundle name cannot be null.");
        Objects.requireNonNull(locale, "Locale cannot be null.");
        String s2 = "/" + bname.replace('.', '/');
        this.tclass_ = this.getClass();
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String variant = locale.getVariant();
        LOGGER.trace("language {}, country {}, variant {}", language, country, variant);
        String s = s2 + "_" + language + "_" + country + "_" + variant + ".properties";
        if (this.readResourceNamed(s)) {
            this.resourceID_ = s;
            return;
        }
        s = s2 + "_" + language + "_" + country + ".properties";
        if (this.readResourceNamed(s)) {
            this.resourceID_ = s;
            return;
        }
        s = s2 + "_" + language + ".properties";
        if (this.readResourceNamed(s)) {
            this.resourceID_ = s;
            return;
        }
        s = s2 + ".properties";
        if (this.readResourceNamed(s)) {
            this.resourceID_ = s;
            return;
        }
        LOGGER.warn("No match for property bundle " + s2);
    }

    public PropertyList(URL url) throws IOException, JDOMException {
        LOGGER.trace("url");
        try (InputStream is = url.openStream();){
            this.parse(is);
        }
    }

    public PropertyList(InputStream is) throws IOException, JDOMException {
        LOGGER.trace("is");
        this.parse(is);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readResourceNamed(String rname) {
        LOGGER.trace("trying resource  {}", (Object)rname);
        try (InputStream is = this.tclass_.getResourceAsStream(rname);){
            this.parse(is);
            boolean bl = true;
            return bl;
        }
        catch (NullPointerException npe) {
            return false;
        }
        catch (Exception exc) {
            LOGGER.error("Exception reading resource {}: {}", (Object)rname, (Object)exc.toString());
            return false;
        }
    }

    private synchronized void parse(InputStream is) throws FileNotFoundException, IOException, JDOMException {
        Document document = EasyXmlParser.parseDocument(is);
        Element root = document.getRootElement();
        if (this.phash_ == null) {
            this.phash_ = new Hashtable(root.getChildren().size());
        }
        for (Element node : root.getChildren()) {
            String nodeName = node.getName();
            if (nodeName.equals("property")) {
                this.parseProperty(node);
                continue;
            }
            LOGGER.warn("Unrecognized element '{}'", (Object)nodeName);
        }
    }

    private synchronized void parseProperty(Element node) {
        if (node.getAttribute("name") == null) {
            LOGGER.warn("Node is missing 'name' attribute'");
            return;
        }
        Hashtable<String, String> ahash = new Hashtable<String, String>(node.getAttributes().size());
        for (Attribute a : node.getAttributes()) {
            if (a == null) continue;
            ahash.put(a.getName().toLowerCase(), a.getValue());
        }
        this.phash_.put(node.getAttribute("name").getValue().toLowerCase(), new Object[]{node.getText(), ahash});
    }

    public String getString(String pkey) {
        if (this.phash_ == null) {
            throw new PropertyNotFoundException("Property list is not initialized.");
        }
        Object[] prop = this.phash_.get(pkey.toLowerCase());
        if (prop == null) {
            throw new PropertyNotFoundException("No property named " + pkey);
        }
        if (prop[0] == null) {
            throw new PropertyNotFoundException("Property " + pkey + " has no value");
        }
        return (String)prop[0];
    }

    public String getAttribute(String pkey, String akey) {
        if (this.phash_ == null) {
            throw new PropertyNotFoundException("Property list is not initialized.");
        }
        Object[] prop = this.phash_.get(pkey.toLowerCase());
        if (prop == null) {
            throw new PropertyNotFoundException("No property named " + pkey);
        }
        if (prop[1] == null) {
            return null;
        }
        if (prop[1] instanceof Hashtable) {
            Hashtable ahash = (Hashtable)prop[1];
            return (String)ahash.get(akey.toLowerCase());
        }
        return null;
    }

    public String getResourceID() {
        return this.resourceID_;
    }
}

