/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util;

import java.awt.GraphicsEnvironment;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlatformUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static int javaMajor_;
    private static boolean isMac_;
    private static boolean isMacEAWT_;
    private static boolean isWindows_;
    private static String osVersion_;
    private static int osMajor_;
    private static boolean isMacDarkMode_;

    public static boolean isMacintosh() {
        return isMac_;
    }

    public static boolean isOldMacintoshAPI() {
        return isMacEAWT_;
    }

    public static boolean isMacintoshDarkMode() {
        return isMacDarkMode_;
    }

    public static boolean isWindows() {
        return isWindows_;
    }

    public static boolean isLinuxEtc() {
        return !isMac_ && !isWindows_;
    }

    public static String getOSVersionString() {
        return osVersion_;
    }

    public static int getOSMajor() {
        return osMajor_;
    }

    public static int getJavaMajorVersion() {
        return javaMajor_;
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static void printSystemProperties() {
        Properties props = System.getProperties();
        Set<String> pkeyset = props.stringPropertyNames();
        ArrayList<String> pkeylist = new ArrayList<String>();
        pkeylist.addAll(pkeyset);
        Collections.sort(pkeylist);
        for (String pkey : pkeylist) {
            LOGGER.trace("pkey {}, value {}", (Object)pkey, (Object)System.getProperty(pkey));
        }
    }

    public static void printUIProperties() {
        if (PlatformUtils.isHeadless()) {
            LOGGER.trace("Running headless.");
            return;
        }
        try {
            UIDefaults defs = UIManager.getDefaults();
            Set uikeyset = defs.keySet();
            LOGGER.trace("UI key count {}", (Object)uikeyset.size());
            ArrayList<String> uikeylist = new ArrayList<String>();
            for (Object oo : uikeyset) {
                uikeylist.add(oo.toString());
            }
            Collections.sort(uikeylist);
            for (String uikey : uikeylist) {
                LOGGER.trace("uikey {}, value {}", (Object)uikey, defs.get(uikey));
            }
        }
        catch (Exception exc) {
            LOGGER.trace("{}", (Object)exc.toString());
        }
    }

    private PlatformUtils() {
    }

    static {
        String jVersion = null;
        try {
            javaMajor_ = -1;
            jVersion = System.getProperty("java.version");
            if (jVersion.startsWith("1.")) {
                jVersion = jVersion.substring(2);
            }
            jVersion = jVersion.replaceFirst("\\D*", "");
            jVersion = jVersion.replaceFirst("\\..*", "");
            javaMajor_ = Integer.valueOf(jVersion);
        }
        catch (Exception ignore) {
            LOGGER.warn("Unable to parse Java version, {}.", (Object)jVersion);
        }
        LOGGER.trace("Java major {}", (Object)javaMajor_);
        try {
            String osName = System.getProperty("os.name");
            isMac_ = osName.contains("Mac");
            isWindows_ = osName.contains("Windows");
        }
        catch (Exception ignore) {
            LOGGER.warn("No OS name in system properties?");
        }
        try {
            osMajor_ = -1;
            String osVersion_ = System.getProperty("os.version");
            if (isMac_) {
                osVersion_ = osVersion_.replaceFirst("10\\.", "");
            }
            osVersion_ = osVersion_.replaceFirst("\\..*", "");
            LOGGER.trace("os ver " + osVersion_);
            osMajor_ = Integer.valueOf(osVersion_);
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to parse OS version to int, {}.", (Object)osVersion_);
        }
        try {
            if (isMac_ || osMajor_ >= 14) {
                String dmStr = System.getProperty("macos.DarkMode");
                if (dmStr == null) {
                    dmStr = System.getProperty("DarkMode");
                }
                isMacDarkMode_ = dmStr != null && dmStr.equalsIgnoreCase("true");
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to parse DarkMode property");
        }
        if (isMac_ && javaMajor_ == 8) {
            try {
                Class.forName("com.apple.eawt.Application");
                isMacEAWT_ = true;
                LOGGER.trace("Found eawt.Application; setting isMacEAWT true");
            }
            catch (Exception exc) {
                LOGGER.warn("Exception checking for Apple Java API: {}", (Object)exc.toString());
            }
        }
    }
}

