/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.JDCalendar;
import gov.nasa.giss.time.JulianType;
import gov.nasa.giss.time.PatternTime;
import gov.nasa.giss.time.TimeFormatter;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class JulianTime
implements PatternTime,
TimeFormatter {
    private JulianType epoch_ = JulianType.SIMPLE;
    private SimpleDateFormat dtFormat_;
    private JDCalendar calendar_ = new JDCalendar();

    public JulianTime() throws ParseException {
        this(JulianType.SIMPLE);
    }

    public JulianTime(JulianType epoch) throws ParseException {
        this.dtFormat_ = new SimpleDateFormat();
        this.dtFormat_.setCalendar(this.calendar_);
        this.dtFormat_.applyPattern("yyyy-MM-dd HH");
        this.setEpoch(epoch);
    }

    public void setEpoch(JulianType epoch) {
        this.epoch_ = epoch;
    }

    @Override
    public String getPattern() {
        return this.dtFormat_.toPattern();
    }

    @Override
    public void applyPattern(String pattern) {
        this.dtFormat_.applyPattern(pattern);
    }

    @Override
    public String format(Number delta) {
        return this.format(delta.doubleValue());
    }

    @Override
    public String format(long delta) {
        return this.format((double)delta);
    }

    @Override
    public String format(double jd) {
        if (jd == Double.NaN) {
            throw new IllegalArgumentException("Cannot use NaN double value.");
        }
        if (Double.isInfinite(jd)) {
            throw new IllegalArgumentException("Cannot use infinite double value.");
        }
        this.calendar_.setJulianDate(this.epoch_, jd);
        return this.dtFormat_.format(this.calendar_.getTime());
    }
}

