/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

public enum ClockType {
    MEAN_SOLAR("LMST", "Local Mean Solar Time (LMST)"),
    TRUE_SOLAR("LTST", "Local True Solar Time (LTST)"),
    MEAN_ZONAL("LMZT", "Local Mean Zonal Time"),
    PLANETARY("T", "Planetary Time");

    private String abbrev_;
    private String lname_;

    private ClockType(String abbrev, String lname) {
        this.abbrev_ = abbrev;
        this.lname_ = lname;
    }

    public String toString() {
        return this.lname_;
    }

    public String getAbbreviation() {
        return this.abbrev_;
    }

    public String getLongName() {
        return this.lname_;
    }

    public boolean matches(String text) {
        return this.idMatches(text) | this.nameMatches(text);
    }

    public boolean idMatches(String text) {
        return this.abbrev_.equalsIgnoreCase(text);
    }

    public boolean nameMatches(String lname) {
        return this.lname_.equalsIgnoreCase(lname);
    }

    public static ClockType matching(String s) {
        for (ClockType id : ClockType.values()) {
            if (!id.matches(s)) continue;
            return id;
        }
        return null;
    }
}

