/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.prefs;

import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesHash;
import gov.nasa.giss.prefs.PreferencesListener;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.PlatformUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.channels.FileChannel;
import java.util.Objects;
import javax.swing.event.EventListenerList;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPreferences
extends PreferencesHash {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private File prefsFile_;
    private File settingsFile_;
    private String domain_;
    private String appName_;
    private static boolean prefsFileDisabled_;
    private EventListenerList listenerList_ = new EventListenerList();

    protected AbstractPreferences() {
        this(null, null);
    }

    protected AbstractPreferences(String domain, String appName) {
        this.domain_ = domain;
        this.appName_ = appName;
        this.setName(appName);
        this.restoreDefaults();
    }

    public String getAppName() {
        return this.appName_;
    }

    public static void disablePreferencesFile() {
        prefsFileDisabled_ = true;
    }

    public static boolean isPreferencesFileDisabled() {
        return prefsFileDisabled_;
    }

    public void read() {
        if (prefsFileDisabled_) {
            LOGGER.warn("Prefs file usage has been disabled.");
            return;
        }
        if (this.appName_ == null) {
            LOGGER.warn("No app name available to determine preferences file location.");
            return;
        }
        this.findPrefs(this.domain_, this.appName_);
        if (this.prefsFile_ == null) {
            System.err.println("Null prefs file.");
            return;
        }
        if (this.prefsFile_.exists()) {
            this.read(this.prefsFile_);
        } else if (this.prefsFile_ != null) {
            try {
                this.save(this.prefsFile_);
            }
            catch (Exception exc) {
                LOGGER.warn("Unable to create preferences file.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                this.prefsFile_ = null;
            }
        }
    }

    private void findPrefs(String domain, String appName) {
        Objects.requireNonNull(domain, "Prefs domain cannot be null.");
        Objects.requireNonNull(appName, "Application name cannot be null.");
        if (prefsFileDisabled_) {
            LOGGER.warn("Prefs file usage has been disabled.");
            return;
        }
        String homeDir = System.getProperty("user.home");
        String pathSep = System.getProperty("file.separator");
        String prefsDname = null;
        String prefsFname = null;
        if (PlatformUtils.isMacintosh()) {
            prefsDname = homeDir + pathSep + "Library" + pathSep + "Preferences";
            prefsFname = domain + "." + appName + ".prefs.xml";
        } else if (domain.equals("gov.nasa.giss")) {
            prefsDname = homeDir + pathSep + ".gissjava";
            prefsFname = appName.toLowerCase() + ".xml";
        } else {
            String xd = domain;
            xd.replace('.', '_');
            prefsDname = homeDir + pathSep + "." + xd;
            prefsFname = appName.toLowerCase() + ".xml";
        }
        File prefsDir = null;
        File prefsFile = null;
        try {
            prefsDir = new File(prefsDname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (prefsDir == null) {
            LOGGER.warn("Unable to create prefs directory File object.");
            return;
        }
        try {
            prefsFile = new File(prefsDir, prefsFname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (prefsFile == null) {
            LOGGER.warn("Unable to create prefs File object.");
            return;
        }
        if (!prefsDir.exists()) {
            prefsDir.mkdirs();
        }
        if (!prefsDir.exists()) {
            LOGGER.warn("Unable to find preferences directory.");
            LOGGER.warn("Setting prefs file to null.");
            prefsFile = null;
        }
        this.prefsFile_ = prefsFile;
    }

    public synchronized void read(File f) {
        block15: {
            if (f == null || !f.exists()) {
                System.err.println("Null prefs file.");
                return;
            }
            this.settingsFile_ = f;
            try (FileInputStream is = new FileInputStream(this.settingsFile_);){
                this.readStream(is);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception reading prefs. Ignoring past settings");
                if (!LOGGER.isDebugEnabled()) break block15;
                exc.printStackTrace();
            }
        }
    }

    public void revert() {
        System.err.println("AbstractPreferences revert calls read");
        if (this.settingsFile_ != null) {
            this.read(this.settingsFile_);
        } else if (this.prefsFile_ != null) {
            this.read(this.prefsFile_);
        } else {
            this.restoreDefaults();
        }
    }

    public abstract void restoreDefaults();

    protected abstract void readStream(InputStream var1) throws IOException, JDOMException;

    @Override
    public void set(String key, Object value) {
        super.set(key, value);
        this.firePreferenceChanged(key);
    }

    public void save() {
        File backup_;
        block59: {
            block58: {
                if (prefsFileDisabled_) {
                    LOGGER.warn("Prefs file usage has been disabled.");
                    return;
                }
                if (this.prefsFile_ == null) {
                    LOGGER.warn("No prefs file has been identified.");
                    return;
                }
                backup_ = null;
                try {
                    String bkpName = this.prefsFile_.toString() + "_bkp";
                    backup_ = new File(bkpName);
                }
                catch (Exception exc) {
                    backup_ = null;
                }
                if (backup_ != null) {
                    try (FileInputStream fis = new FileInputStream(this.prefsFile_);
                         FileOutputStream fos = new FileOutputStream(backup_);
                         FileChannel inputChannel = fis.getChannel();
                         FileChannel outputChannel = fos.getChannel();){
                        outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
                    }
                    catch (Exception exc) {
                        LOGGER.warn("Exception saving prefs backup: {}", (Object)exc.toString());
                        if (!LOGGER.isTraceEnabled()) break block58;
                        exc.printStackTrace();
                    }
                }
            }
            try {
                this.save(this.prefsFile_);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception saving preferences: {}", exc);
                if (!LOGGER.isTraceEnabled()) break block59;
                exc.printStackTrace();
            }
        }
        if (backup_ != null && backup_.exists()) {
            backup_.delete();
        }
    }

    public void save(File f) {
        block16: {
            try (FileOutputStream fos = new FileOutputStream(f);){
                this.saveStream(fos);
            }
            catch (Exception exc) {
                if (PlatformUtils.isHeadless()) {
                    LOGGER.warn("failed to write prefs due to exception:", (Object)exc.toString());
                } else {
                    GuiUtils.showSlowMessage(null, "File Error", "I encountered an error while savings preferences.\n" + exc.toString());
                }
                if (!LOGGER.isDebugEnabled()) break block16;
                exc.printStackTrace();
            }
        }
    }

    protected abstract void saveStream(OutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferenceListener(PreferencesListener l) {
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            this.listenerList_.add(PreferencesListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreferenceListener(PreferencesListener l) {
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            this.listenerList_.remove(PreferencesListener.class, l);
        }
    }

    protected void firePreferenceChanged(String pname) {
        Object o = this.get(pname);
        PreferencesEvent e = new PreferencesEvent(pname, o);
        Object[] list = this.listenerList_.getListenerList();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof PreferencesListener)) continue;
            ((PreferencesListener)list[i]).preferenceChanged(e);
        }
    }
}

