/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.map.kml.KMLDataResourceList;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.lang.invoke.MethodHandles;
import javax.swing.JComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanUnderlayComboBox
extends JComboBox<Object>
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static KMLDataResourceList kmlList_ = PanUtils.getUnderlayResourceList();
    private final boolean firstIsNone_ = true;

    public PanUnderlayComboBox(PanGuiSize size) {
        super(kmlList_.toArray());
        this.insertItemAt("None", 0);
        this.setSelectedIndex(0);
        this.setMaximumSize(this.getPreferredSize());
        kmlList_.addListDataListener(this);
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            this.setSelectedIndex(0);
        } else {
            super.setSelectedItem(item);
        }
    }

    public void setSelectedItem(KMLData item) {
        if (item == null) {
            this.setSelectedIndex(0);
        } else {
            super.setSelectedItem(item);
        }
    }

    public void setSelectedItemByName(String item) {
        if (item == null) {
            this.setSelectedIndex(0);
            return;
        }
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            if (!this.getItemAt(i).toString().equals(item)) continue;
            super.setSelectedIndex(i);
            return;
        }
    }

    public KMLData getUnderlay() {
        Object o = this.getSelectedItem();
        if (o instanceof KMLData) {
            return (KMLData)o;
        }
        return null;
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        LOGGER.debug("Not implemented.");
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        boolean offset = true;
        KMLDataResourceList oList = PanUtils.getUnderlayResourceList();
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        for (int i = index0; i <= index1; ++i) {
            Object olay = oList.getBackingObject(i);
            this.insertItemAt(olay, i + 1);
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        int index1;
        boolean offset = true;
        int index = this.getSelectedIndex();
        int index0 = e.getIndex0();
        for (int i = index1 = e.getIndex1(); i >= index0; --i) {
            this.removeItemAt(i + 1);
        }
        if (index >= index0 + 1 && index <= index1 + 1) {
            if (index0 > 0) {
                this.setSelectedIndex(index0 - 1 + 1);
            } else {
                this.setSelectedIndex(index0 + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanUnderlayComboBox panUnderlayComboBox = this;
        synchronized (panUnderlayComboBox) {
            kmlList_.removeListDataListener(this);
            this.removeAll();
        }
    }
}

