/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.ui.spinner.IntSpinner;

public final class PanIntSpinner
extends IntSpinner {
    private PanIntSpinner(PanGuiSize size, String name, int value, int min, int max, int step) {
        super(value, min, max, step);
        if (value < min) {
            this.setValue(min);
        } else if (value > max) {
            this.setValue(max);
        }
        if (name != null) {
            this.setName(name);
        }
        if (size == PanGuiSize.SMALL) {
            PanGuiUtils.setSizeSmall(this);
        }
    }

    public static PanIntSpinner create(String name, int value, int min, int max, int step) {
        return new PanIntSpinner(PanGuiSize.REGULAR, name, value, min, max, step);
    }

    public static PanIntSpinner create(int value, int min, int max, int step) {
        return new PanIntSpinner(PanGuiSize.REGULAR, null, value, min, max, step);
    }

    public static PanIntSpinner createSmall(String name, int value, int min, int max, int step) {
        return new PanIntSpinner(PanGuiSize.SMALL, name, value, min, max, step);
    }

    public static PanIntSpinner createSmall(int value, int min, int max, int step) {
        return new PanIntSpinner(PanGuiSize.SMALL, null, value, min, max, step);
    }

    public static PanIntSpinner createDivs(String name, int value) {
        return new PanIntSpinner(PanGuiSize.REGULAR, name, value, 1, 20, 1);
    }

    public static PanIntSpinner createSmallDivs(String name, int value) {
        return new PanIntSpinner(PanGuiSize.SMALL, name, value, 1, 20, 1);
    }

    public static PanIntSpinner createWeight(String name, int value, int max) {
        return new PanIntSpinner(PanGuiSize.REGULAR, name, value, 0, max, 1);
    }

    public static PanIntSpinner createSmallWeight(String name, int value, int max) {
        return new PanIntSpinner(PanGuiSize.SMALL, name, value, 0, max, 1);
    }

    public static PanIntSpinner createWeightX5(String name, int value, int max) {
        return new PanIntSpinner(PanGuiSize.REGULAR, name, value, 0, max, 5);
    }

    public static PanIntSpinner createSmallWeightX5(String name, int value, int max) {
        return new PanIntSpinner(PanGuiSize.SMALL, name, value, 0, max, 5);
    }

    public static PanIntSpinner createPct(String name, int value) {
        return new PanIntSpinner(PanGuiSize.REGULAR, name, value, 0, 100, 1);
    }

    public static PanIntSpinner createPct(int value) {
        return new PanIntSpinner(PanGuiSize.REGULAR, null, value, 0, 100, 1);
    }

    public static PanIntSpinner createSmallPct(String name, int value) {
        return new PanIntSpinner(PanGuiSize.SMALL, name, value, 0, 100, 1);
    }
}

