/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanGridLabelStep;
import javax.swing.JComboBox;

public class PanGridLabelStepComboBox
extends JComboBox<PanGridLabelStep> {
    private PanGridLabelStepComboBox(PanGuiSize size, String name) {
        super(PanGridLabelStep.values());
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    @Override
    public void setSelectedItem(Object item) {
        PanGridLabelStep gs;
        int i;
        if (item == null) {
            super.setSelectedItem(PanGridLabelStep.NONE);
            return;
        }
        if (item instanceof PanGridLabelStep) {
            super.setSelectedItem(item);
            return;
        }
        int isize = this.getItemCount();
        if (item instanceof Integer) {
            int ii = (Integer)item;
            for (i = 0; i < isize; ++i) {
                gs = (PanGridLabelStep)this.getItemAt(i);
                if (ii != gs.getStep()) continue;
                super.setSelectedItem(gs);
                return;
            }
        }
        String s = item.toString();
        for (i = 0; i < isize; ++i) {
            gs = (PanGridLabelStep)this.getItemAt(i);
            if (!gs.toString().equals(s)) continue;
            super.setSelectedItem(gs);
            return;
        }
    }

    public void setSelectedItem(int step) {
        this.setStep(step);
    }

    public void setStep(int step) {
        PanGridLabelStep gstep = PanGridLabelStep.matching(step);
        super.setSelectedItem(gstep);
    }

    public int getStep() {
        PanGridLabelStep gs = (PanGridLabelStep)this.getSelectedItem();
        return gs.getStep();
    }

    public static PanGridLabelStepComboBox create(String name) {
        return new PanGridLabelStepComboBox(PanGuiSize.REGULAR, name);
    }

    public static PanGridLabelStepComboBox createSmall(String name) {
        return new PanGridLabelStepComboBox(PanGuiSize.SMALL, name);
    }
}

