/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.ui.EnumComboBox;
import gov.nasa.giss.util.DescribedItem;

public final class PanEnumComboBox
extends EnumComboBox {
    private PanEnumComboBox(PanGuiSize size, String name, Class<? extends DescribedItem> eclass) {
        super(eclass);
        if (!eclass.isEnum()) {
            throw new IllegalArgumentException("Not an enum");
        }
        DescribedItem[] vals = eclass.getEnumConstants();
        if (vals.length > 0 && !(vals[0] instanceof DescribedItem)) {
            throw new IllegalArgumentException(eclass + " not instanceof DescribedItem");
        }
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    public void stripDown(DescribedItem ... items) {
        int i;
        int isize = this.getItemCount();
        for (i = 0; i < isize; ++i) {
            this.removeItemAt(0);
        }
        for (i = 0; i < items.length; ++i) {
            this.addItem(items[i]);
        }
    }

    public static PanEnumComboBox create(Class<? extends DescribedItem> eclass) {
        return new PanEnumComboBox(PanGuiSize.REGULAR, null, eclass);
    }

    public static PanEnumComboBox create(String name, Class<? extends DescribedItem> eclass) {
        return new PanEnumComboBox(PanGuiSize.REGULAR, name, eclass);
    }

    public static PanEnumComboBox createSmall(String name, Class<? extends DescribedItem> eclass) {
        return new PanEnumComboBox(PanGuiSize.SMALL, name, eclass);
    }

    public static PanEnumComboBox createSmall(Class<? extends DescribedItem> eclass) {
        return new PanEnumComboBox(PanGuiSize.SMALL, null, eclass);
    }
}

